<?php
include 'db.php';
$db = new DB();
$conn = $db->getConnection();

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $saleId = intval($_POST['sales_id']);
    $amount = floatval($_POST['pay_amount']); // Using your naming
    $sales_type = 'Sale';
    $is_online_payment = isset($_POST['is_online_payment']) ? 1 : 0;
    $ref_number = $_POST['ref_number'] ?? null;
    
    if ($saleId && $amount > 0) {

        // Auto-generated payment note
        $note = "Initial Payment for Sale ID | $saleId";

        // Start transaction to avoid partial updates
        $conn->begin_transaction();

        try {
            
            date_default_timezone_set('Asia/Colombo');
            $startDatecustome = new DateTime();
            $mysqlDatecustom = $startDatecustome->format('Y-m-d H:i:s');
            
            // 1. Insert payment
            $stmt = $conn->prepare("
                INSERT INTO payment (sales_id, sales_type, note, amount,online_payment,ref_id, date)
                VALUES (?, ?, ?, ?, ?, ?, ?)
            ");
            $stmt->bind_param("issdsss", $saleId, $sales_type, $note, $amount,$is_online_payment,$ref_number,$mysqlDatecustom);
            $stmt->execute();
            $stmt->close();

            // 2. Update sales table pay_amount
            $updateStmt = $conn->prepare("
                UPDATE sales 
                SET pay_amount = pay_amount + ?
                WHERE id = ?
            ");
            $updateStmt->bind_param("di", $amount, $saleId);
            $updateStmt->execute();
            $updateStmt->close();

            // Commit transaction
            $conn->commit();

            header("Location: view_sale.php?id=" . $saleId);
            exit;
        } catch (Exception $e) {
            $conn->rollback();
            echo "Error: " . $e->getMessage();
        }

    } else {
        echo "Invalid sale ID or amount.";
    }
}
?>
