<?php
require 'dom/dompdf/vendor/autoload.php';

use Dompdf\Dompdf;
use Dompdf\Options;

$options = new Options();
$options->set('isHtml5ParserEnabled', true);
$options->set('isRemoteEnabled', true); // allow external images

$dompdf = new Dompdf($options);

if (!empty($_POST['html'])) {
    $htmlContent = $_POST['html'];

    // Add custom font and table-based layout
    $html = '
    <html>
    <head>
        <style>
            @font-face {
                font-family: "SinhalaFont";
                src: url("fonts/NotoSansSinhala-Regular.ttf") format("truetype");
            }
            body {
                font-family: "SinhalaFont", sans-serif;
                font-size: 12px;
            }
            table {
                width: 100%;
                border-collapse: collapse;
                margin-bottom: 15px;
            }
            td {
                vertical-align: top;
                border: 1px solid #000;
                padding: 10px;
                box-sizing: border-box;
            }
        </style>
    </head>
    <body>
        

        ' . $htmlContent . '
    </body>
    </html>
    ';

    $dompdf->loadHtml($html, 'UTF-8');
    $dompdf->setPaper('A4', 'portrait');
    $dompdf->render();

    // Direct download
    $dompdf->stream("agreement.pdf", ["Attachment" => false]);
} else {
    echo "No content received!";
}
