<?php
require 'dom/dompdf/vendor/autoload.php';

use Dompdf\Dompdf;
use Dompdf\Options;

$options = new Options();
$options->set('isHtml5ParserEnabled', true);
$options->set('isRemoteEnabled', true); // allow external images

$dompdf = new Dompdf($options);

// Example: check POST html content
if (!empty($_POST['html'])) {
    $htmlContent = $_POST['html'];

    // Thermal printer styling
    $html = '
    <html>
    <head>
        <style>
            @font-face {
                font-family: "SinhalaFont";
                src: url("fonts/NotoSansSinhala-Regular.ttf") format("truetype");
            }
            
        </style>
    </head>
    <body>
        ' . $htmlContent . '
    </body>
    </html>
    ';

    // Load HTML
    $dompdf->loadHtml($html, 'UTF-8');

    // Set paper to 80mm width, auto height
    $width = 80; // in mm
    $height = 200; // arbitrary height, Dompdf will handle page overflow
     $dompdf->setPaper('A4', 'portrait');

    $dompdf->render();

    // Force download / direct print
    $dompdf->stream("receipt.pdf", ["Attachment" => false]);
} else {
    echo "No content received!";
}
