<?php include 'header.php'; ?>
<?php

if (isset($_GET['delete_rental'])) {
    $rental_id = $_GET['delete_rental'];
    $db = new DB();

    // 1. Get all issued items for this rental
    $stmt = $db->getConnection()->prepare("SELECT item_id FROM rental_items_issuse WHERE rental_id = ?");
    $stmt->bind_param("i", $rental_id);
    $stmt->execute();
    $result = $stmt->get_result();

    // 2. Loop through items and activate them again
    while ($row = $result->fetch_assoc()) {
        $item_id = $row['item_id'];

        $update = $db->update('rental_items', ['status' => 'Active'], $item_id);
        if (!$update) {
            echo "<script>alert('Failed to update item status for item ID $item_id');</script>";
        }
    }

    // 3. Delete from rental_items_issuse
    $stmt = $db->getConnection()->prepare("DELETE FROM rental_items_issuse WHERE rental_id = ?");
    $stmt->bind_param("i", $rental_id);
    $stmt->execute();

    // 4. Delete from payment table by sales_id (assuming sales_id == rental_id)
    $stmt = $db->getConnection()->prepare("DELETE FROM payment WHERE sales_id = ?");
    $stmt->bind_param("i", $rental_id);
    $stmt->execute();

    // 5. Delete from rental
    $stmt = $db->getConnection()->prepare("DELETE FROM rental WHERE id = ?");
    $stmt->bind_param("i", $rental_id);
    $stmt->execute();

   
}
?>
     <!-- Content wrapper -->
          <div class="content-wrapper">
            <!-- Content -->
            <div class="container-xxl flex-grow-1 container-p-y">
                <div class="card">
              <div class="row" style="  
    padding-top: 1%;
    padding-bottom: 1%;
    align-items: baseline;
    padding-left: 1%;
    border-radius: 8px;padding-right: 1%;">
                <div class="col-lg-6">
                    <span style="font-weight: 800;font-size: 18px;color: black;">Rental Bills Managment</span>
                </div>
                <div class="col-lg-6" style="align-content: stretch;
    display: flex
;
    flex-wrap: wrap;
    flex-direction: row;
    justify-content: flex-end;">
                                <a
                              
                              class="btn btn-primary" href="new_rental.php">
                              Add New
                            </a>

                      

                          </div>
                        </div>
</div>

<div class="card mt-3 p-3">
  <form method="GET" class="row g-3">
    <div class="col-md-2">
      <label for="rental_id" class="form-label">Rental ID</label>
      <input type="text" name="rental_id" id="rental_id" class="form-control" value="<?= isset($_GET['rental_id']) ? htmlspecialchars($_GET['rental_id']) : '' ?>">
    </div>
    <div class="col-md-3">
      <label for="customer_id" class="form-label">Customer ID</label>
      <input type="text" name="customer_id" id="customer_id" class="form-control" value="<?= isset($_GET['customer_id']) ? htmlspecialchars($_GET['customer_id']) : '' ?>">
    </div>
    <div class="col-md-3">
      <label for="customer_name" class="form-label">Customer Name</label>
      <input type="text" name="customer_name" id="customer_name" class="form-control" value="<?= isset($_GET['customer_name']) ? htmlspecialchars($_GET['customer_name']) : '' ?>">
    </div>
    <div class="col-md-2">
      <label for="start_date" class="form-label">From Date</label>
      <input type="date" name="start_date" id="start_date" class="form-control" value="<?= isset($_GET['start_date']) ? htmlspecialchars($_GET['start_date']) : '' ?>">
    </div>
    <div class="col-md-2">
      <label for="end_date" class="form-label">To Date</label>
      <input type="date" name="end_date" id="end_date" class="form-control" value="<?= isset($_GET['end_date']) ? htmlspecialchars($_GET['end_date']) : '' ?>">
    </div>
    <div class="col-md-2 d-flex align-items-end">
  <div class="form-check">
    <input class="form-check-input" type="checkbox" name="show_due_only" id="show_due_only" <?= isset($_GET['show_due_only']) ? 'checked' : '' ?>>
    <label class="form-check-label" for="show_due_only">
      Show Due Only
    </label>
  </div>
</div>

    <div class="col-md-12 text-end">
      <button type="submit" class="btn btn-success mt-3">Filter</button>
      <a href="complete_rental.php" class="btn btn-secondary mt-3">Reset</a>
    </div>
  </form>
</div>

                      <div class="card" style="margin-top: 2%;">
                <h5 class="card-header">Completed Rental</h5>
                <div class="table-responsive text-nowrap">
                                  <?php
                                  $db = new DB();




$conditions = ["r.status = 'Completed'"];

if (!empty($_GET['rental_id'])) {
    $rental_id = intval($_GET['rental_id']);
    $conditions[] = "r.id = $rental_id";
}

if (!empty($_GET['customer_id'])) {
    $customer_id = $db->getConnection()->real_escape_string($_GET['customer_id']);
    $conditions[] = "r.customer_id LIKE '%$customer_id%'";
}

if (!empty($_GET['customer_name'])) {
    $customer_name = $db->getConnection()->real_escape_string($_GET['customer_name']);
    $conditions[] = "c.name LIKE '%$customer_name%'";
}

if (!empty($_GET['start_date'])) {
    $start_date = $db->getConnection()->real_escape_string($_GET['start_date']);
    $conditions[] = "DATE(r.created_date) >= '$start_date'";
}

if (!empty($_GET['end_date'])) {
    $end_date = $db->getConnection()->real_escape_string($_GET['end_date']);
    $conditions[] = "DATE(r.created_date) <= '$end_date'";
}

// Add this condition if checkbox is checked
if (isset($_GET['show_due_only']) && $_GET['show_due_only'] === 'on') {
    $conditions[] = "CAST(r.total AS DECIMAL(10,2)) > CAST(r.pay_amount AS DECIMAL(10,2))";
}

$whereClause = implode(' AND ', $conditions);
$sql = "SELECT r.*, c.name as customer_name 
        FROM rental r 
        LEFT JOIN customers c ON r.customer_id = c.id_number 
        WHERE $whereClause 
        ORDER BY r.id DESC";


$pendingRentals = $db->rawQuery($sql);


?>
                  <table class="table">
                    <thead>
                      <tr>
                        <th>Rental ID</th>
                        <th>Cus. Name</th>
                        <th>Cus. ID</th>
                        <th>Total Bill</th>
                        <th>Total Payed</th>
                        <th>Total Due</th>
                        <th>Status</th>
                        <th>Date</th>
                        <th>Action</th>
                      </tr>
                    </thead>
                  <tbody class="table-border-bottom-0">
<?php
if (empty($pendingRentals)) {
    echo "<tr><td colspan='8'>No rentals found.</td></tr>";
} else {
    foreach ($pendingRentals as $rental) {
?>
<tr>
  <td><?= htmlspecialchars($rental['id']) ?></td>
  <td><?= htmlspecialchars($rental['customer_name']) ?></td> <!-- FIXED HERE -->
  <td><?= htmlspecialchars($rental['customer_id']) ?></td>
  <td><?= number_format($rental['total'], 2) ?></td> <!-- FIXED: use 'total' -->
  <td><?= number_format($rental['pay_amount'], 2) ?></td> 
  <?php 
  $due = floatval($rental['total']) - floatval($rental['pay_amount']); 
?>
<td><?= number_format($due, 2) ?></td> 
  <td><span class="badge bg-success"><?= htmlspecialchars($rental['status']) ?></span></td>
  <td><?= date('Y-m-d', strtotime($rental['created_date'])) ?></td> <!-- FIXED: use 'created_date' -->
     <td><a href="view_rental.php?id=<?= $rental['id'] ?>" class="btn btn-primary">View</a> </td>
</tr>
<?php
    }
}
?>
</tbody>

                  </table>
                </div>
              </div>

                      </div>
                    </div>
                  </div>
                </div>
                </div>
              </div>
             
            </div>

            <script>
                $(document).ready(function () {
  $('#itemTable').DataTable();
});

            </script>
            <!-- / Content -->
<?php include 'footer.php'; ?>