<?php include 'header.php'; ?>
<?php

if (isset($_POST['add_item'])) {
    $cus_name     = $_POST['cus_name'];
    $cus_email    = $_POST['cus_email'];
    $cus_phone    = $_POST['cus_phone'];
    $cus_company  = $_POST['cus_company'];
    $cus_address  = $_POST['cus_address'];
    $cus_balance  = $_POST['cus_balance'];

    $cus_id = $_POST['cus_id'];
    // Handle file uploads
    $cus_fingerprint = '';
    $cus_photo = '';

    // Create uploads folder if not exists
    if (!is_dir('uploads/customers')) {
        mkdir('uploads/customers', 0777, true);
    }

    // Upload Fingerprint
    if (isset($_FILES['cus_fringer_print']) && $_FILES['cus_fringer_print']['error'] === 0) {
        $fp_tmp = $_FILES['cus_fringer_print']['tmp_name'];
        $fp_name = uniqid('fp_') . '_' . basename($_FILES['cus_fringer_print']['name']);
        $fp_dest = 'uploads/customers/' . $fp_name;

        if (move_uploaded_file($fp_tmp, $fp_dest)) {
            $cus_fingerprint = $fp_dest;
        }
    }

    // Upload Customer Photo
    if (isset($_FILES['cus_c_photo']) && $_FILES['cus_c_photo']['error'] === 0) {
        $photo_tmp = $_FILES['cus_c_photo']['tmp_name'];
        $photo_name = uniqid('photo_') . '_' . basename($_FILES['cus_c_photo']['name']);
        $photo_dest = 'uploads/customers/' . $photo_name;

        if (move_uploaded_file($photo_tmp, $photo_dest)) {
            $cus_photo = $photo_dest;
        }
    }
    //Upload ID Front Photo
    
    if (isset($_FILES['cus_id_front_photo']) && $_FILES['cus_id_front_photo']['error'] === 0) {
        $photo_tmps = $_FILES['cus_id_front_photo']['tmp_name'];
        $photo_names = uniqid('photo_') . '_' . basename($_FILES['cus_id_front_photo']['name']);
        $photo_dests = 'uploads/customers/' . $photo_names;

        if (move_uploaded_file($photo_tmps, $photo_dests)) {
            $cus_id_front_photo = $photo_dests;
        }
    }

    //Upload ID Back Photo
    
    if (isset($_FILES['cus_id_back_photo']) && $_FILES['cus_id_back_photo']['error'] === 0) {
        $photo_tmpss = $_FILES['cus_id_back_photo']['tmp_name'];
        $photo_namess = uniqid('photo_') . '_' . basename($_FILES['cus_id_back_photo']['name']);
        $photo_destss = 'uploads/customers/' . $photo_namess;

        if (move_uploaded_file($photo_tmpss, $photo_destss)) {
            $cus_id_back_photo = $photo_destss;
        }
    }

    // Insert into DB
    $DB = new DB();
    $insert = $DB->insert('customers', [
        'name'        => $cus_name,
        'email'       => $cus_email,
        'phone'       => $cus_phone,
        'company'     => $cus_company,
        'address'     => $cus_address,
        'fingerprint' => $cus_fingerprint,
        'photo'       => $cus_photo,
        'balance'     => $cus_balance,
        'id_number'   => $cus_id,
        'cus_id_back_photo'   => $cus_id_back_photo,
        'cus_id_front_photo'   => $cus_id_front_photo
    ]);

    if ($insert) {
        echo "<script>window.location.href = 'customers.php?success=Customer added successfully';</script>";
    } else {
        echo "<script>window.location.href = 'customers.php?error=Failed to add customer';</script>";
    }
}



// Deactivate customer
if (isset($_GET['deactivate_cus'])) {
    $deactivate = $_GET['deactivate_cus'];
    $DB = new DB();
    $data = [
        'status' => 'Deactivated'
    ];
    $success = $DB->update('customers', $data, $deactivate);

    if ($success) {
        echo "<script>window.location.href = 'customers.php?success=Success! Customer deactivated.';</script>";
    } else {
        echo "<script>window.location.href = 'customers.php?error=Error! Could not deactivate customer.';</script>";
    }
}

// Activate customer
if (isset($_GET['activate_cus'])) {
    $activate = $_GET['activate_cus'];
    $DB = new DB();
    $data = [
        'status' => 'Active'
    ];
    $success = $DB->update('customers', $data, $activate);

    if ($success) {
        echo "<script>window.location.href = 'customers.php?success=Success! Customer activated.';</script>";
    } else {
        echo "<script>window.location.href = 'customers.php?error=Error! Could not activate customer.';</script>";
    }
}

?>
     <!-- Content wrapper -->
          <div class="content-wrapper">
            <!-- Content -->
            <div class="container-xxl flex-grow-1 container-p-y">
            	<div class="card">
              <div class="row" style="  
    padding-top: 3%;
    padding-bottom: 3%;
    align-items: baseline;
    padding-left: 3%;
    border-radius: 8px;padding-right: 3%;">
              	<div class="col-lg-6">
              		<span style="font-weight: 800;font-size: 15px;color: black;">Customers Managment</span>
              	</div>
              	<div class="col-lg-6" style="align-content: stretch;
    display: flex
;
    flex-wrap: wrap;
    flex-direction: row;
    justify-content: flex-end;">
              					<button
                              type="button"
                              class="btn btn-primary"
                              data-bs-toggle="modal"
                              data-bs-target="#backDropModal">
                              Add New Customer
                            </button>

                            <!-- Modal -->
                            <div class="modal fade" id="backDropModal" data-bs-backdrop="static" tabindex="-1">
                              <div class="modal-dialog">
                                <form class="modal-content" method="POST" action="customers.php" enctype="multipart/form-data">
                                  <div class="modal-header">
                                    <h5 class="modal-title" id="backDropModalTitle">Add New Customer</h5>
                                    <button
                                      type="button"
                                      class="btn-close"
                                      data-bs-dismiss="modal"
                                      aria-label="Close"></button>
                                  </div>
                                  <div class="modal-body">
                                    <div class="row">
                                      <div class="col mb-6">
                                        <label for="nameBackdrop"  class="form-label">Customer Name</label>
                                        <input
                                          type="text"
                                          id="nameBackdrop"
                                          class="form-control"
                                          placeholder="Enter Customer Name" name="cus_name"  required="required" />
                                      </div>
                                      <div class="col mb-6">
                                        <label for="nameBackdrop"  class="form-label">Customer Email</label>
                                        <input
                                          type="text"
                                          id="nameBackdrop"
                                          class="form-control"
                                          placeholder="Enter Customer Email" name="cus_email"  value="noemail@gmail.com" />
                                      </div>
                                    </div>
                                    <div class="row">
                                      <div class="col mb-6">
                                        <label for="nameBackdrop"  class="form-label">Customer Phone</label>
                                        <input
                                          type="text"
                                          id="nameBackdrop"
                                          class="form-control"
                                          placeholder="Enter Customer Phone" name="cus_phone"  required="required" />
                                      </div>
                                      <div class="col mb-6">
                                        <label for="nameBackdrop"  class="form-label">Customer Company</label>
                                        <input
                                          type="text"
                                          id="nameBackdrop"
                                          class="form-control"
                                          placeholder="Enter Customer Company" name="cus_company"  />
                                      </div>
                                    </div>
                                    <div class="row g-6" >
                                      <div class="col mb-0">
                                        <label for="emailBackdrop" class="form-label">Customer ID Number</label>
                                       <input
                                          type="text"
                                          id="nameBackdrop"
                                          class="form-control"
                                          placeholder="Enter Customer ID Number" name="cus_id"  />
                                      </div>
                                      
                                    </div>
                                    <div class="row g-6" style="margin-top:1%;">
                                      <div class="col mb-0">
                                        <label for="emailBackdrop" class="form-label">Customer Address</label>
                                        <textarea name="cus_address" class="form-control"></textarea>
                                      </div>
                                      
                                    </div>
                                     <div class="row g-6" style="margin-top:1%;">
                                      <div class="col mb-0">
                                        <label for="emailBackdrop" class="form-label">Customer Fingerprint</label>
                                        <input type="file" name="cus_fringer_print" class="form-control" required="required">
                                      </div>
                                      
                                    </div>
                                    <div class="row g-6" style="margin-top:1%;">
  <div class="col mb-0">
    <label class="form-label">Customer Photo</label>
    <input type="file" id="cus_c_photo" name="cus_c_photo" class="form-control" accept="image/*" capture="environment" required>
    <button type="button" class="btn btn-primary mt-2" onclick="openWebcam('cus_c_photo')">Capture by Camera</button>
    <img id="preview_cus_c_photo" src="" style="width:100%;margin-top:10px;display:none;border:1px solid #ccc;padding:4px;border-radius:8px;">
    
    
    



  </div>
</div>

<div class="row g-6" style="margin-top:1%;">
  <div class="col mb-0">
    <label class="form-label">Customer ID Front</label>
    <input type="file" id="cus_id_front_photo" name="cus_id_front_photo" class="form-control" accept="image/*" capture="environment" required>
   <button type="button" class="btn btn-primary mt-2" onclick="openWebcam('cus_id_front_photo')">Capture by Camera</button>
    <img id="preview_cus_id_front_photo" src="" style="width:100%;margin-top:10px;display:none;border:1px solid #ccc;padding:4px;border-radius:8px;">
  </div>
</div>

<div class="row g-6" style="margin-top:1%;">
  <div class="col mb-0">
    <label class="form-label">Customer ID Back</label>
    <input type="file" id="cus_id_back_photo" name="cus_id_back_photo" class="form-control" accept="image/*" capture="environment" required>
    <button type="button" class="btn btn-primary mt-2" onclick="openWebcam('cus_id_back_photo')">Capture by Camera</button>
    <img id="preview_cus_id_back_photo" src="" style="width:100%;margin-top:10px;display:none;border:1px solid #ccc;padding:4px;border-radius:8px;">
  </div>
</div>
                                    <div class="row g-6" style="margin-top:1%;">
                                      <div class="col mb-0">
                                        <label for="emailBackdrop" class="form-label">Customer Balance</label>
                                        <input
                                          type="number"
                                          id="emailBackdrop"
                                          class="form-control"
                                          placeholder="50.00" name="cus_balance" required="required" value="0"/>
                                      </div>
                                      
                                    </div>
                                  </div>
                                  <div class="modal-footer">
                                    <button type="button" class="btn btn-label-secondary" data-bs-dismiss="modal">
                                      Close
                                    </button>
                                    <input type="submit" class="btn btn-primary" name="add_item" value="Submit">
                                  </div>
                                </form>
                              </div>
                            </div>


                          </div>
                        </div>
</div>

 <div class="card" style="margin-bottom: 1rem;margin-top: 2%;">
      <h5 class="card-header">Filter Customers</h5>
      <form method="GET" action="" class="row g-3 p-3">
        <div class="col-md-4">
          <input type="text" name="name" class="form-control" placeholder="Filter by Name" value="<?= htmlspecialchars($nameFilter) ?>">
        </div>
        <div class="col-md-4">
          <input type="text" name="email" class="form-control" placeholder="Filter by Email" value="<?= htmlspecialchars($emailFilter) ?>">
        </div>
        <div class="col-md-4">
          <input type="text" name="phone" class="form-control" placeholder="Filter by Phone" value="<?= htmlspecialchars($phoneFilter) ?>">
        </div>
        <div class="col-md-12 text-end">
          <button type="submit" class="btn btn-primary">Filter</button>
          <a href="customers.php" class="btn btn-secondary">Reset</a>
        </div>
      </form>
    </div>

  

                      <div class="card" style="margin-top: 2%;">
                <h5 class="card-header">Customers</h5>
                <div class="table-responsive text-nowrap">
                 <table class="table">
  <thead>
    <tr>
      <th>Customer ID</th>
      <th>Name</th>
      <th>Email</th>
      <th>Phone</th>
      <th>Company</th>
      <th>Balance</th>
      <th>Status</th>
      <th>Date Added</th>
      <th>Actions</th>
    </tr>
  </thead>
  <tbody class="table-border-bottom-0">
    <?php

     $db = new DB();

// Get filter values from GET request
$nameFilter = $_GET['name'] ?? '';
$emailFilter = $_GET['email'] ?? '';
$phoneFilter = $_GET['phone'] ?? '';

// Prepare WHERE conditions and parameters
$where = [];
$params = [];
$types = '';

if (!empty($nameFilter)) {
    $where[] = "name LIKE ?";
    $params[] = "%" . $nameFilter . "%";
    $types .= 's';
}

if (!empty($emailFilter)) {
    $where[] = "email LIKE ?";
    $params[] = "%" . $emailFilter . "%";
    $types .= 's';
}

if (!empty($phoneFilter)) {
    $where[] = "phone LIKE ?";
    $params[] = "%" . $phoneFilter . "%";
    $types .= 's';
}

$sql = "SELECT * FROM customers";

if (!empty($where)) {
    $sql .= " WHERE " . implode(" AND ", $where);
}

$sql .= " ORDER BY id DESC";

$conn = $db->getConnection();
$stmt = $conn->prepare($sql);

if ($params) {
    $stmt->bind_param($types, ...$params);
}

$stmt->execute();
$result = $stmt->get_result();
$allCustomers = $result->fetch_all(MYSQLI_ASSOC);

      if (empty($allCustomers)) {
        echo "<tr><td colspan='9'>No customers found.</td></tr>";
      } else {
        foreach ($allCustomers as $customer) {
          ?>
          <tr>
            <td><?php echo htmlspecialchars($customer['id']); ?></td>
            <td><?php echo htmlspecialchars($customer['name']); ?></td>
            <td><?php echo htmlspecialchars($customer['email']); ?></td>
            <td><?php echo htmlspecialchars($customer['phone']); ?></td>
            <td><?php echo htmlspecialchars($customer['company']); ?></td>
            <td>
              <?php 
                $balance = $customer['balance'];
                if (floor($balance) == $balance) {
                  $balance = number_format($balance, 2, '.', '');
                }
                echo htmlspecialchars($balance);
              ?>
            </td>
            <td><span class="badge"><?php echo htmlspecialchars($customer['status']); ?></span></td>
            <td><?php echo htmlspecialchars($customer['reg_date']); ?></td>
            <td>
              <div class="dropdown">
                <button type="button" class="btn p-0 dropdown-toggle hide-arrow" data-bs-toggle="dropdown">
                  <i class="icon-base bx bx-dots-vertical-rounded"></i>
                </button>
                <div class="dropdown-menu">
                  <a class="dropdown-item" href="single_customer.php?id=<?php echo $customer["id"]; ?>"><i class="icon-base bx bx-edit-alt me-1"></i> Edit</a>
                  <?php
                    if ($customer['status'] == "Active" && $userRole != "Staff") {
                      ?>
                      <a class="dropdown-item" href="customers.php?deactivate_cus=<?php echo $customer["id"]; ?>"><i class="icon-base bx bx-user-x me-1"></i> Deactivate</a>
                      <?php
                    } else if ($customer['status'] == "Deactivated") {
                      ?>
                      <a class="dropdown-item" href="customers.php?activate_cus=<?php echo $customer["id"]; ?>"><i class="icon-base bx bx-user-check me-1"></i> Activate</a>
                      <?php
                    }
                  ?>
                </div>
              </div>
            </td>
          </tr>
          <?php
        }
      }
    ?>
  </tbody>
</table>

                </div>
              </div>

                      </div>
                    </div>
                  </div>
                </div>
              	</div>
              </div>
             
            </div>
            
            
            <div class="modal fade" id="cameraModal" tabindex="-1">
  <div class="modal-dialog">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title">Capture Photo</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
      </div>
      <div class="modal-body text-center">
        <video id="cameraStream" width="100%" autoplay></video>
        <canvas id="captureCanvas" style="display:none;"></canvas>
        <button type="button" class="btn btn-success mt-2" onclick="takeSnapshot()">Capture</button>
      </div>
    </div>
  </div>
</div>


<script>
let stream;
let currentInputId = ""; // Track which field we are capturing for

function openWebcam(inputId) {
  currentInputId = inputId; // store which file input we are targeting
  navigator.mediaDevices.getUserMedia({ video: true })
    .then(s => {
      stream = s;
      document.getElementById('cameraStream').srcObject = s;
      var modal = new bootstrap.Modal(document.getElementById('cameraModal'));
      modal.show();
    })
    .catch(err => {
      alert("Camera not accessible: " + err);
    });
}

function takeSnapshot() {
  const video = document.getElementById('cameraStream');
  const canvas = document.getElementById('captureCanvas');
  const context = canvas.getContext('2d');
  canvas.width = video.videoWidth;
  canvas.height = video.videoHeight;
  context.drawImage(video, 0, 0, canvas.width, canvas.height);

  // Convert to data URL (base64)
  const imageData = canvas.toDataURL('image/png');

  // Set preview image dynamically
  const preview = document.getElementById("preview_" + currentInputId);
  preview.src = imageData;
  preview.style.display = "block";

  // Stop camera
  stream.getTracks().forEach(track => track.stop());

  // Close modal
  bootstrap.Modal.getInstance(document.getElementById('cameraModal')).hide();

  // Attach the snapshot to the correct file input
  fetch(imageData)
    .then(res => res.blob())
    .then(blob => {
      let file = new File([blob], "capture.png", { type: "image/png" });
      let dataTransfer = new DataTransfer();
      dataTransfer.items.add(file);
      document.getElementById(currentInputId).files = dataTransfer.files;
    });
}
</script>

<script>

document.querySelectorAll('input[type="file"]').forEach(input => {
  input.addEventListener("change", function(event) {
    const file = event.target.files[0];
    if (file) {
      const reader = new FileReader();
      reader.onload = function(e) {
        const preview = document.getElementById("preview_" + input.id);
        preview.src = e.target.result;
        preview.style.display = "block";
      };
      reader.readAsDataURL(file);
    }
  });
});
</script>
            <script>
            	$(document).ready(function () {
  $('#itemTable').DataTable();
});

            </script>
            <!-- / Content -->
<?php include 'footer.php'; ?>