<?php
$site_link = "https://chandanaengineering.com";
class DB {
    private $conn;

    // Constructor: create database connection
    public function __construct() {
        $this->conn = new mysqli("localhost", "chankwwi_main", "Supun878@96","chankwwi_main");

        if ($this->conn->connect_error) {
            die("Database connection failed: " . $this->conn->connect_error);
        }
    }

    // SELECT ALL rows
   public function selectAll($table) {
    // Simple query to get all rows
    $sql = "SELECT * FROM `$table`";

    // Run query
    $result = $this->conn->query($sql);

    // Check for errors or empty result
    if ($result === false) {
        // Query failed
        echo "Query Error: " . $this->conn->error;
        return [];
    }

    if ($result->num_rows == 0) {
        // No rows found
        return [];
    }

    // Fetch all rows as associative arrays
    return $result->fetch_all(MYSQLI_ASSOC);
}

public function selectSumStock($item_id) {
    $stmt = $this->conn->prepare("SELECT SUM(amount) as total FROM stock WHERE item_id = ?");
    $stmt->bind_param("i", $item_id);
    $stmt->execute();
    $result = $stmt->get_result();
    return $result->fetch_assoc();
}


public function rawQuery($sql) {
    $result = $this->conn->query($sql);

    if ($result === false) {
        echo "Query Error: " . $this->conn->error;
        return [];
    }

    return $result->fetch_all(MYSQLI_ASSOC);
}



public function getConnection() {
    return $this->conn;
}

    // SELECT ONE by ID
    public function selectById($table, $id) {
        $stmt = $this->conn->prepare("SELECT * FROM `$table` WHERE id = ?");
        $stmt->bind_param("i", $id);
        $stmt->execute();
        return $stmt->get_result()->fetch_assoc();
    }

    // SELECT ONE by Recode
    public function selectByOne($table, $c_name, $id) {
        $stmt = $this->conn->prepare("SELECT * FROM `$table` WHERE `$c_name` = ?");
        $stmt->bind_param("s", $id);
        $stmt->execute();
        return $stmt->get_result()->fetch_assoc();
    }

    // INSERT new row
    public function insert($table, $data) {
        $columns = implode(", ", array_keys($data));
        $placeholders = implode(", ", array_fill(0, count($data), '?'));
        $types = str_repeat("s", count($data)); // assuming all string
        $values = array_values($data);

        $stmt = $this->conn->prepare("INSERT INTO `$table` ($columns) VALUES ($placeholders)");
        if (!$stmt) {
            die("Prepare failed: " . $this->conn->error);
        }

        $stmt->bind_param($types, ...$values);
        if ($stmt->execute()) {
            return true;
        } else {
            echo "Insert Error: " . $stmt->error;
            return false;
        }
    }


    // UPDATE row by ID
    public function update($table, $data, $id) {
        $set = "";
        $types = "";
        $values = [];

        foreach ($data as $key => $value) {
            $set .= "$key = ?, ";
            $types .= "s";
            $values[] = $value;
        }

        $set = rtrim($set, ", ");
        $types .= "i"; // ID type
        $values[] = $id;

        $stmt = $this->conn->prepare("UPDATE `$table` SET $set WHERE id = ?");
        $stmt->bind_param($types, ...$values);
        return $stmt->execute();
    }

    // DELETE row by ID
    public function delete($table, $id) {
        $stmt = $this->conn->prepare("DELETE FROM `$table` WHERE id = ?");
        $stmt->bind_param("i", $id);
        return $stmt->execute();
    }

    // Close connection
    public function close() {
        $this->conn->close();
    }
}
