<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

require 'db.php';

$db = new DB();
$conn = $db->getConnection();

$saleId = isset($_GET['id']) ? (int)$_GET['id'] : 0;
if (!$saleId) {
    die("Invalid Sale ID");
}

$conn->begin_transaction();

try {
    // Step 1: Get all sold items for the sale
$itemsQuery = $conn->prepare("
    SELECT item_id, qty 
    FROM sales_items_sold 
    WHERE sales_id = ?
");
$itemsQuery->bind_param("i", $saleId);
$itemsQuery->execute();
$itemsResult = $itemsQuery->get_result();

// Step 2: Restore stock by inserting positive "in" stock entries
while ($item = $itemsResult->fetch_assoc()) {
    $itemId = $item['item_id'];
    $qty = $item['qty'];

    $insertStock = $conn->prepare("INSERT INTO stock (item_id, stock_type, amount) VALUES (?, 'in', ?)");
    $insertStock->bind_param("ii", $itemId, $qty);
    $insertStock->execute();
    $insertStock->close();
}

    $itemsQuery->close();

    // 3. Delete payments related to this sale
    $deletePayments = $conn->prepare("DELETE FROM payment WHERE sales_id = ? AND sales_type = 'Sale'");
    $deletePayments->bind_param("i", $saleId);
    $deletePayments->execute();
    $deletePayments->close();

    // 4. Delete sales items sold for this sale
    $deleteItemsSold = $conn->prepare("DELETE FROM sales_items_sold WHERE sales_id = ?");
    $deleteItemsSold->bind_param("i", $saleId);
    $deleteItemsSold->execute();
    $deleteItemsSold->close();

    // 5. Delete the sale record itself
    $deleteSale = $conn->prepare("DELETE FROM sales WHERE id = ?");
    $deleteSale->bind_param("i", $saleId);
    $deleteSale->execute();
    $deleteSale->close();

    $conn->commit();

    header("Location: sales_list.php?success=Sale+deleted+successfully");
    exit;
} catch (Exception $e) {
    $conn->rollback();
    die("Error deleting sale: " . $e->getMessage());
}
