<?php 
include 'header.php';
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// DB connection
$db = new DB();
$conn = $db->getConnection();

// Total Payment In (sum of positive amounts)
$salesQuery = $conn->query("SELECT SUM(amount) AS total_sales FROM payment");
$sales = $salesQuery->fetch_assoc()['total_sales'] ?? 0;

// Total Payment In (positive amounts)
$inQuery = $conn->query("SELECT SUM(amount) AS total_in FROM payment WHERE amount > 0");
$totalIn = $inQuery->fetch_assoc()['total_in'] ?? 0;

// Total Payment Out (absolute sum of negative amounts)
$outQuery = $conn->query("SELECT SUM(ABS(amount)) AS total_out FROM payment WHERE amount < 0");
$totalOut = $outQuery->fetch_assoc()['total_out'] ?? 0;

// Total Item Rental 
$itemsQuery = $conn->query("SELECT COUNT(`id`) as totalitems FROM `rental_items` WHERE `status` = 'Issued'");
$totalItems = $itemsQuery->fetch_assoc()['totalitems'] ?? 0;


$pendingQuery = $conn->query("SELECT COUNT(`id`) as pending_rental FROM `rental` WHERE `status` = 'Pending'");
$pendingCount = $pendingQuery->fetch_assoc()['pending_rental'] ?? 0;


$completedQuery = $conn->query("SELECT COUNT(`id`) as completed_rental FROM `rental` WHERE `status` = 'Completed'");
$completedCount = $completedQuery->fetch_assoc()['completed_rental'] ?? 0;


$totalQuery = $conn->query("SELECT COUNT(`id`) as total_rental FROM `rental`");
$totalCount = $totalQuery->fetch_assoc()['total_rental'] ?? 0;


$netProfit = $totalIn - $totalOut;

$monthlyData = [];

$query = $conn->query("
  SELECT 
    DATE_FORMAT(date, '%Y-%m') AS month, 
    SUM(CASE WHEN amount > 0 THEN amount ELSE 0 END) AS total_in,
    SUM(CASE WHEN amount < 0 THEN ABS(amount) ELSE 0 END) AS total_out
  FROM payment
  GROUP BY month
  ORDER BY month
");

while ($row = $query->fetch_assoc()) {
  $total_in = (float) $row['total_in'];
  $total_out = (float) $row['total_out'];
  $profit = $total_in - $total_out;

  $monthlyData[] = [
    'month' => $row['month'],
    'in' => $total_in,
    'out' => $total_out,
    'profit' => $profit
  ];
}


// Prepare for JavaScript
$monthsJS = json_encode(array_column($monthlyData, 'month'));
$inJS = json_encode(array_column($monthlyData, 'in'));
$outJS = json_encode(array_column($monthlyData, 'out'));
$profitJS = json_encode(array_column($monthlyData, 'profit'));


?>

          <!-- Content wrapper -->
          <div class="content-wrapper">
            <!-- Content -->
            <div class="container-xxl flex-grow-1 container-p-y">
              <div class="row">
                <div class="col-xxl-8 mb-6 order-0">
                  <div class="card">
                    <div class="d-flex align-items-start row">
                      <div class="col-sm-7">
                        <div class="card-body">
                          <h5 class="card-title text-primary mb-3">Welcome to CHANDANA ENGINEERING & CONSTRUCTION🎉</h5>
                          <p class="mb-6">
                            You can manage all in one<br />Check your shortcut.
                          </p>

                          <a href="new_rental.php" class="btn btn-sm btn-outline-primary">New Rental</a>
                          <a href="new_sale.php" class="btn btn-sm btn-outline-primary">New Sales</a>
                        </div>
                      </div>
                      <div class="col-sm-5 text-center text-sm-left">
                        <div class="card-body pb-0 px-0 px-md-6">
                          <img
                            src="2.png"
                            height="175"
                            alt="View Badge User" />
                        </div>
                      </div>
                    </div>
                  </div>
                </div>
                 <?php 
                    if ($userRole != "Staff") {
                      ?>
                <div class="col-xxl-4 col-lg-12 col-md-4 order-1" style="display: none;">
                  <div class="row">
                    <div class="col-lg-6 col-md-12 col-6 mb-6">
                      <div class="card h-100">
                        <div class="card-body">
                          <div class="card-title d-flex align-items-start justify-content-between mb-4">
                            <div class="avatar flex-shrink-0">
                              <img
                                src="UI/assets/img/icons/unicons/chart-success.png"
                                alt="chart success"
                                class="rounded" />
                            </div>
                          
                          </div>
                          <p class="mb-1">Total Item In Rental</p>
                          <h4 class="card-title mb-3"><?= $totalItems ?></h4>
                        
                        </div>
                      </div>
                    </div>


                   
                  <div class="col-lg-6 col-md-12 col-6 mb-6">
                      <div class="card h-100">
                        <div class="card-body">
                          <div class="card-title d-flex align-items-start justify-content-between mb-4">
                            <div class="avatar flex-shrink-0">
                              <img
                                src="UI/assets/img/icons/unicons/wallet-info.png"
                                alt="wallet info"
                                class="rounded" />
                            </div>
                           
                          </div>
                          <p class="mb-1">Total Profit</p>
                          <h4 class="card-title mb-3">LKR. <?= number_format($sales, 2) ?></h4>
                        </div>
                      </div>
                    </div>
                    
                   


                  </div>
                </div>
                  <?php
                    }
                    ?>
                <!-- Total Revenue -->
                <?php if ($userRole != "Staff") {
                      ?>
                <!--/ Total Revenue -->
                <div class="col-12 col-md-8 col-lg-12 col-xxl-4 order-3 order-md-2 profile-report" style="display:none;">
                  <div class="row">
                    <div class="col-6 mb-6 payments">
                      <div class="card h-100">
                        <div class="card-body">
                          <div class="card-title d-flex align-items-start justify-content-between mb-4">
                            <div class="avatar flex-shrink-0">
                              <img src="UI/assets/img/icons/unicons/paypal.png" alt="paypal" class="rounded" />
                            </div>
                           
                          </div>
                          <p class="mb-1">Total Payment In</p>
                          <h4 class="card-title mb-3">LKR. <?= number_format($totalIn, 2) ?></h4>
                        </div>
                      </div>
                    </div>

 
                    <div class="col-6 mb-6 transactions">
                      <div class="card h-100">
                        <div class="card-body">
                          <div class="card-title d-flex align-items-start justify-content-between mb-4">
                            <div class="avatar flex-shrink-0">
                              <img src="UI/assets/img/icons/unicons/cc-primary.png" alt="Credit Card" class="rounded" />
                            </div>
                            
                          </div>
                          <p class="mb-1">Total Payment Out</p>
                          <h4 class="card-title mb-3">LKR. <?= number_format($totalOut, 2) ?></h4>
                        </div>
                      </div>

                    </div>
                   
                  </div>

                </div>
              </div>
               <?php } ?>
              <div class="row" style="display:none;">
                <!-- Order Statistics -->
                <div class="col-lg-4">
                  <div class="card h-100">
                    <div class="card-header d-flex justify-content-between">
                      <div class="card-title mb-0">
                        <h5 class="mb-1 me-2">Rental Statistics</h5>
                        <p class="card-subtitle"><?= $totalCount ?> Total Rental</p>
                      </div>
                     
                    </div>
                    <div class="card-body">
                      <div class="d-flex justify-content-between align-items-center mb-6">
                        <canvas id="statusPieChart" width="400" height="400"></canvas>

                      </div>
                      
                    </div>
                  </div>
                </div>
                <!--/ Order Statistics -->

                <!-- Expense Overview -->
     <?php if ($userRole != "Staff") {
                      ?>
                  <div class="col-lg-8" style="display:none;">
 <div class="card mt-4">
  <div class="card-header">
    <h5 class="mb-0">Monthly Payment Summary</h5>
  </div>
  <div class="card-body">
    <canvas id="monthlyLineChart" width="600" height="300"></canvas>
  </div>
</div>



                  </div>


                <?php } ?>
                </div>
                <!--/ Expense Overview -->

              
                <!--/ Transactions -->
              </div>
            </div>
            <!-- / Content -->
            <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
            <script>
  const ctx = document.getElementById('statusPieChart').getContext('2d');

  new Chart(ctx, {
    type: 'pie',
    data: {
      labels: ['Pending', 'Completed'],
      datasets: [{
        label: 'Status Count',
        data: [<?= $pendingCount ?>, <?= $completedCount ?>],
        backgroundColor: ['#f39c12', '#28a745'],
        borderWidth: 1
      }]
    },
    options: {
      responsive: true,
      plugins: {
        legend: {
          position: 'bottom'
        },
        tooltip: {
          enabled: true
        }
      }
    }
  });
</script>


<script>
const months = <?= $monthsJS ?>;
const inData = <?= $inJS ?>;
const outData = <?= $outJS ?>;
const profitData = <?= $profitJS ?>;

const lineCtx = document.getElementById('monthlyLineChart').getContext('2d');

new Chart(lineCtx, {
  type: 'line',
  data: {
    labels: months,
    datasets: [
      {
        label: 'Payment In',
        data: inData,
        borderColor: '#28a745',
        backgroundColor: 'rgba(40, 167, 69, 0.1)',
        tension: 0.3,
        fill: true
      },
      {
        label: 'Payment Out',
        data: outData,
        borderColor: '#dc3545',
        backgroundColor: 'rgba(220, 53, 69, 0.1)',
        tension: 0.3,
        fill: true
      },
      {
        label: 'Profit',
        data: profitData,
        borderColor: '#007bff',
        backgroundColor: 'rgba(0, 123, 255, 0.1)',
        tension: 0.3,
        fill: true
      }
    ]
  },
  options: {
    responsive: true,
    scales: {
      y: {
        beginAtZero: true,
        ticks: {
          callback: function(value) {
            return 'LKR ' + value.toLocaleString();
          }
        }
      }
    },
    plugins: {
      tooltip: {
        callbacks: {
          label: function(context) {
            return context.dataset.label + ': LKR ' + context.parsed.y.toLocaleString();
          }
        }
      },
      legend: {
        position: 'bottom'
      }
    }
  }
});

</script>


     <?php
     include 'footer.php';
   ?>