<?php include 'header.php'; ?>

<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);
$db = new DB();

// Handle filters
$whereClauses = [];
$params = [];
$types = "";

// Filter by item name
// Filter by item name (partial match)
if (!empty($_GET['item_name'])) {
    $whereClauses[] = "`rental_items`.`name` LIKE ?";
    $params[] = "%" . $_GET['item_name'] . "%";
    $types .= "s";
}

// ✅ Filter by item code (partial match)
if (!empty($_GET['item_code'])) {
    $whereClauses[] = "`rental_items`.`item_code` LIKE ?";
    $params[] = "%" . $_GET['item_code'] . "%";
    $types .= "s";
}


// Filter by date range (TO and FROM based on c_date)
if (!empty($_GET['from_date']) && !empty($_GET['to_date'])) {
    $whereClauses[] = "`rental_items_issuse`.`r_date` BETWEEN ? AND ?";
    $params[] = $_GET['from_date'];
    $params[] = $_GET['to_date'];
    $types .= "ss";
}

// Always include status condition
$whereClauses[] = "`rental_items_issuse`.`status` = 'Recived'";

// Build SQL
$query = "SELECT 
            `rental_items_issuse`.`item_id`,
            `rental_items_issuse`.`price`,
            `rental_items_issuse`.`rental_days`,
            `rental_items_issuse`.`total`,
            `rental_items_issuse`.`c_date`,
            `rental_items_issuse`.`r_date`,
            `rental_items`.`name`,
            `rental_items`.`item_code`
          FROM `rental_items_issuse`
          JOIN `rental_items` 
            ON `rental_items`.`id` = `rental_items_issuse`.`item_id`";

// Add WHERE conditions
if (!empty($whereClauses)) {
    $query .= " WHERE " . implode(" AND ", $whereClauses);
}

$query .= " ORDER BY `rental_items_issuse`.`id` DESC";

// Prepare and execute
$stmt = $db->getConnection()->prepare($query);

if (!empty($params)) {
    $stmt->bind_param($types, ...$params);
}

$stmt->execute();
$result = $stmt->get_result();
$allItems = $result->fetch_all(MYSQLI_ASSOC);
?>

<div class="content-wrapper">
    <div class="container-xxl flex-grow-1 container-p-y">

        <div class="card">
            <div class="card-body">
                <form method="GET" class="row g-3">
                    <div class="col-md-3">
                        <label class="form-label">Item Name</label>
                        <input type="text" name="item_name" value="<?= htmlspecialchars($_GET['item_name'] ?? '') ?>" class="form-control" placeholder="Enter Item Name">
                    </div>
                     <div class="col-md-3">
                        <label class="form-label">Item Code</label>
                        <input type="text" name="item_code" value="<?= htmlspecialchars($_GET['item_code'] ?? '') ?>" class="form-control" placeholder="Enter Item Code">
                    </div>
                    <div class="col-md-2">
                        <label class="form-label">From Date</label>
                        <input type="date" name="from_date" value="<?= htmlspecialchars($_GET['from_date'] ?? '') ?>" class="form-control">
                    </div>
                    <div class="col-md-2">
                        <label class="form-label">To Date</label>
                        <input type="date" name="to_date" value="<?= htmlspecialchars($_GET['to_date'] ?? '') ?>" class="form-control">
                    </div>
                    <div class="col-md-2" style="margin-top: 32px;">
                        <button type="submit" class="btn btn-primary w-100">Filter</button>
                    </div>
                </form>
            </div>
        </div>

        <div class="card" style="margin-top: 2%;">
            <h5 class="card-header">Rental Items Report</h5>
            <div class="table-responsive text-nowrap">
                <table class="table">
                    <thead>
                        <tr>
                            <th>Item ID</th>
                            <th>Item Name</th>
                            <th>Item Code</th>
                            <th>Rental Price</th>
                            <th>From</th>
                            <th>To</th>
                            <th>Day</th>
                            <th>Total</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php
                        $totalDays = 0;
                        $grandTotal = 0;

                        if (empty($allItems)) {
                            echo "<tr><td colspan='7'>No rental items found.</td></tr>";
                        } else {
                            foreach ($allItems as $item) {
                                $totalDays += $item['rental_days'];
                                $grandTotal += $item['total'];
                                ?>
                                <tr>
                                    <td><?= htmlspecialchars($item['item_id']) ?></td>
                                    <td><?= htmlspecialchars($item['name']) ?></td>
                                    <td><?= htmlspecialchars($item['item_code']) ?></td>
                                    <td><?= number_format($item['price'], 2) ?></td>
                                    <td><?= htmlspecialchars($item['c_date']) ?></td>
                                    <td><?= htmlspecialchars($item['r_date']) ?></td>
                                    <td><?= htmlspecialchars($item['rental_days']) ?></td>
                                    <td><?= number_format($item['total'], 2) ?></td>
                                </tr>
                                <?php
                            }
                            // Summary row
                            echo "<tr style='font-weight: bold; background: #f2f2f2;'>
                                    <td colspan='5' style='text-align: right;'>Total:</td>
                                    <td>{$totalDays}</td>
                                    <td>" . number_format($grandTotal, 2) . "</td>
                                  </tr>";
                        }
                        ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>

<?php include 'footer.php'; ?>
