<?php include 'header.php'; ?>
<?php
$db = new DB();

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    date_default_timezone_set('Asia/Colombo'); // set PHP timezone

// get current date & time
$startDatecustome = new DateTime();

// format in MySQL DATETIME format
$mysqlDatecustom = $startDatecustome->format('Y-m-d H:i:s');
    $db = new DB();
    $conn = $db->getConnection();

    // Handle receiver photo
    $photoPath = '';
    if (isset($_FILES['receiver_photo']) && $_FILES['receiver_photo']['error'] === 0) {
        $uploadDir = 'uploads/rental/';
        if (!is_dir($uploadDir)) {
            mkdir($uploadDir, 0755, true);
        }

        $filename = basename($_FILES['receiver_photo']['name']);
        $targetFile = $uploadDir . time() . "_" . $filename;

        if (move_uploaded_file($_FILES['receiver_photo']['tmp_name'], $targetFile)) {
            $photoPath = $targetFile;
        } else {
            die("Error uploading photo.");
        }
    }

    // Prepare rental main data
    $rentalData = [
    'customer_id' => $_POST['customer_id'],
    'customer_phone' => $_POST['customer_phone'],
    'customer_email' => $_POST['customer_email'],
    'customer_address' => $_POST['customer_address'],
    'recvier_name' => $_POST['receiver_name'],
    'recvier_id' => $_POST['receiver_id'],
    'recvier_photo' => $photoPath,
    'subtotal' => $_POST['total_amount'],      // base sum of rental items before discount/fee
    'discount' => $_POST['discount'],          // discount applied
    'additional' => $_POST['ex_fee'],  // any extra fee applied
    'total' => $_POST['final_total'],          // final total after discount & fee
    'pay_amount' => $_POST['pay_amount'],
    'status' => 'Pending',
    'created_date' => $mysqlDatecustom
];


    


    // Insert main rental
    $inserted = $db->insert('rental', $rentalData);

    if ($inserted) {
        $rentalId = $conn->insert_id;
       if ($_POST['pay_amount'] != '0') {
    // Insert payment record
    $paymentNote = "Initial Payment For Rental ID | $rentalId";
    $paymentAmount = $_POST['pay_amount'];
    $is_online_payment = isset($_POST['is_online_payment']) ? 1 : 0;
    $ref_number = $_POST['ref_number'] ?? null;



    $paymentStmt = $conn->prepare("INSERT INTO payment (sales_id, sales_type, note, amount,online_payment,ref_id,date) VALUES (?, ?, ?, ?, ?, ?, ?)");
    $salesType = "Rental"; // define the string first
    $paymentStmt->bind_param("sssdsss", $rentalId, $salesType, $paymentNote, $paymentAmount,$is_online_payment,$ref_number,$mysqlDatecustom);

    $paymentStmt->execute();
    $paymentStmt->close();
}



        $rentalItems = json_decode($_POST['rental_items'], true);
       foreach ($rentalItems as $item) {
    // Insert into rental_items_issuse table
    $stmt = $conn->prepare("INSERT INTO rental_items_issuse (rental_id, item_id, price, rental_days, total, estimated_date,qty,code,c_date) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)");
    $stmt->bind_param("iidddssss", 
        $rentalId, 
        $item['item_id'], 
        $item['price'], 
        $item['rental_days'], 
        $item['total'], 
        $item['estimated_date'],
        $item['itemQty'],
        $item['item_code'],
        $mysqlDatecustom
    );
    $stmt->execute();
    $stmt->close(); // always good practice

    // Update rental_items table status to 'Issued'
    $updateStmt = $conn->prepare("UPDATE rental_items SET status = 'Active', qty = qty - ? WHERE id = ?");
    $updateStmt->bind_param("ii", $item['itemQty'], $item['item_id']);
    $updateStmt->execute();
    $updateStmt->close();

}


         echo "<script>window.location.href = 'view_rental.php?success=Rental added successfully&id=$rentalId';</script>";
    } else {
       echo "<script>window.location.href = 'new_rental.php?error=Failed to add Rental';</script>";
    }
}


?>

    <div class="content-wrapper">
  <div class="container-xxl flex-grow-1 container-p-y">
    <div class="card" style="margin-top: 2%;">
      <h5 class="card-header">New Rental</h5>
      <div class="text-nowrap">
        <form style="padding-top:0%;padding-right: 2%;padding-left: 2%;padding-bottom: 3%;" method="POST" enctype="multipart/form-data">
          <span>Customer Details</span>
          <div class="row" style="width: 100%;align-items: center;display: flex;align-content: flex-end;align-items: flex-end;margin-top: 2%;">
            <label style="margin-bottom: 1%;">Enter Or Scan Bar Code (Customer ID)</label>
            <div class="col-lg-6">
              <div class="form-group">
                
                <input type="text" id="id_number_input" name="customer_id" placeholder="Enter Or Scan Bar Code" class="form-control">
              </div>
            </div>
            <div class="col-lg-2">
              <button type="button" class="btn btn-primary" id="search_customer" >Search Customer</button>
            </div>
          </div>
<input type="hidden" name="rental_items" id="rental_items">
<input type="hidden" name="total_amount" id="total_amount">
          <div class="row" style="margin-top:1%">
            <div class="col-lg-3">
              <div class="form-group">
                <label style="margin-bottom:1%">Customer Name</label>
                <input type="text" readonly="readonly" required="required" id="customer_name" name="customer_name" class="form-control" placeholder="Search Customer">
              </div>
            </div>
            <div class="col-lg-3">
              <div class="form-group">
                <label style="margin-bottom:1%">Customer Phone</label>
                <input type="text" readonly="readonly" required="required" id="customer_phone" name="customer_phone" class="form-control" placeholder="Search Customer">
              </div>
            </div>
            <div class="col-lg-3">
              <div class="form-group">
                <label style="margin-bottom:1%">Customer Email</label>
                <input type="email" readonly="readonly" required="required" name="customer_email" id="customer_email" class="form-control" placeholder="Search Customer">
              </div>
            </div>
            <div class="col-lg-3">
              <div class="form-group">
                <label style="margin-bottom:1%">Customer Address</label>
                <textarea class="form-control" readonly="readonly" required="required" id="customer_address" name="customer_address"></textarea>
              </div>
            </div>
          </div>
          <span>Receiver Details</span>
          <div class="row" style="margin-top:2%;    width: 100%;
    align-items: center;
    display: flex
;
    align-content: flex-end;
    align-items: flex-end;
    margin-top: 2%;">
            <div class="col-lg-3">
              <div class="form-group">
                <label>Receiver name</label>
                <input type="text" name="receiver_name" id="receiver_name" class="form-control" required="required">
              </div>
            </div>
            <div class="col-lg-3">
              <div class="form-group">
                <label>Receiver ID Number</label>
                <input type="text" name="receiver_id" id="receiver_id" class="form-control" required="required">
              </div>
            </div>
           <div class="col-lg-3">
  <div class="form-group">
    <label>Receiver Photo</label>
    <input type="file" id="receiver_photo" name="receiver_photo" class="form-control" accept="image/*" capture="environment" required>
    
    <!-- Button to open camera manually -->
    <button type="button" class="btn btn-primary mt-2" onclick="openCamera()">Capture by Camera</button>

    
    <!-- Preview -->
    <img id="preview" src="" alt="Preview" style="width:100%;margin-top:10px;display:none;border:1px solid #ccc;padding:4px;border-radius:8px;">
  </div>
</div>
            
            <div class="col-lg-3">
              <button type="button" class="btn btn-primary" id="same_as_customer_btn">Same As Customer ?</button>
            </div>
          </div>
          <br>
          <span style="margin-top:2%;">Rental Details</span>
          
          <div class="row" style="width: 100%;align-items: center;display: flex;align-content: flex-end;align-items: flex-end;margin-top: 2%;">
            <div class="col-lg-3">
              <label>Search Item Code</label>
              <input type="text" id="item_name" placeholder="Search Item Code" class="form-control" style="text-transform: uppercase;">
            </div>
            <div class="col-lg-3">
              <label>Qty</label>
              <input type="number" id="item_qty" placeholder="Qty" min="1" value="1" class="form-control">
            </div>
            <div class="col-lg-3">
              <label>Estimated date of delivery</label>
              <input type="date" name="estimated_date" class="form-control">
            </div>
            <div class="col-lg-3">
              <button class="btn btn-primary" type="button" style="width:100%;" id="add_to_list_btn">Add to list</button>
            </div>
          </div>
<div class="table-responsive ">
           <table class="table" style="margin-top:4%;">
                <thead>
                  <tr>
                    <th>Item ID</th>
                    <th>Item Code</th>
                    <th>Item Name</th>
                    <th>Item Qty</th>
                    <th>Rental Price</th>
                    <th>Estimated date</th>
                    <th>Rental Dates Count</th>
                    <th>Total</th>
                    <th>Actions</th>
                  </tr>
                </thead>
                <tbody class="table-border-bottom-0">
                     
                </tbody>
            </table>
            </div>
            <br>
            <span>Sub Total : LKR. <span id="subtotal_display">0.00</span></span><br>
<br>
<div class="row" style="margin-top: 1%;display: block;">
  <div class="col-lg-3" style="display: none;">
    <label>Discount (LKR)</label>
    <input type="number" step="0.01" min="0" value="0" id="discount" class="form-control">
  </div>
  <div class="col-lg-3">
    <label>Transport Fee (LKR)</label>
    <input type="number" name="ex_fee" step="0.01" min="0" value="0" id="additional_fee" class="form-control">
  </div>
  <div class="col-lg-3 d-flex align-items-end">
    <button type="button" class="btn btn-info" onclick="updateTotal()">Apply</button>
  </div>
</div>

<br>
<span><strong>Final Total : LKR. <span id="final_total_display">0.00</span></strong></span>

<input type="hidden" name="discount" id="discount_hidden">
<input type="hidden" name="additional_fee" id="additional_fee_hidden">
<input type="hidden" name="final_total" id="final_total">

            <br>
<br>
          <span>Payment Details</span>
          <div style="margin-top:2%;">
            <div style="width: 30%;margin-top:1%;margin-bottom:1%;">
              <label>Paid Amount</label>
              <input type="number" name="pay_amount" class="form-control" value="0">
            </div>
            <div style="width: 30%;margin-top:1%;margin-bottom:1%;">
  <div class="form-check">
    <input type="checkbox" class="form-check-input" id="is_online_payment" name="is_online_payment" value="1">
    <label class="form-check-label" for="is_online_payment">Is Online Payment</label>
  </div>
</div>

<div style="width: 30%;margin-top:1%;margin-bottom:1%;display: none;"  id="refNumberContainer">
  <label for="ref_number">Reference Number</label>
  <input type="text" name="ref_number" id="ref_number" class="form-control" placeholder="Enter Reference ID">
</div>
          </div>
          <input style="margin-top:3%;width:100%;" type="submit" name="add_new_rental" class="btn btn-primary" >
        </form>
      </div>
    </div>
  </div>
</div>

<!-- Webcam Modal -->
<div class="modal fade" id="cameraModal" tabindex="-1" aria-labelledby="cameraModalLabel" aria-hidden="true">
  <div class="modal-dialog modal-dialog-centered modal-lg">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="cameraModalLabel">Capture Photo</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close" onclick="closeWebcam()"></button>
      </div>
      <div class="modal-body text-center">
        <video id="cameraStream" autoplay playsinline style="width:100%;border-radius:8px;"></video>
        <canvas id="captureCanvas" style="display:none;"></canvas>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-success" onclick="takeSnapshot()">📸 Capture</button>
        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal" onclick="closeWebcam()">Close</button>
      </div>
    </div>
  </div>
</div>

<script>
  document.getElementById('is_online_payment').addEventListener('change', function() {
    const refContainer = document.getElementById('refNumberContainer');
    if (this.checked) {
      refContainer.style.display = 'block';
      document.getElementById('ref_number').setAttribute('required', 'required');
    } else {
      refContainer.style.display = 'none';
      document.getElementById('ref_number').removeAttribute('required');
    }
  });
</script>

<script>
let stream;

function openCamera() {
  navigator.mediaDevices.getUserMedia({ video: true })
    .then(s => {
      stream = s;
      document.getElementById("cameraStream").srcObject = s;
      var modal = new bootstrap.Modal(document.getElementById("cameraModal"));
      modal.show();
    })
    .catch(err => {
      alert("Camera not accessible: " + err);
    });
}

function takeSnapshot() {
  const video = document.getElementById("cameraStream");
  const canvas = document.getElementById("captureCanvas");
  const context = canvas.getContext("2d");
  canvas.width = video.videoWidth;
  canvas.height = video.videoHeight;
  context.drawImage(video, 0, 0, canvas.width, canvas.height);

  // Convert to blob & assign to file input
  canvas.toBlob(function(blob) {
    let file = new File([blob], "receiver_photo.png", { type: "image/png" });
    let dataTransfer = new DataTransfer();
    dataTransfer.items.add(file);
    document.getElementById("receiver_photo").files = dataTransfer.files;

    // Show preview
    const preview = document.getElementById("preview");
    preview.src = URL.createObjectURL(blob);
    preview.style.display = "block";
  }, "image/png");

  closeWebcam();
}

function closeWebcam() {
  if (stream) {
    stream.getTracks().forEach(track => track.stop());
  }
}
</script>

<script>
document.getElementById('same_as_customer_btn').addEventListener('click', function () {
  let cus_name = $('#customer_name').val();
  let idNumber = $('#id_number_input').val();
  $('#receiver_name').val(cus_name);
  $('#receiver_id').val(idNumber);
});
</script>
<script>
$('#search_customer').on('click', function() {
    var idNumber = $('#id_number_input').val();

    if (!idNumber) {
        alert('Please enter an ID number.');
        return;
    }

    $.ajax({
        url: 'customer_search_ajax.php', // Change this to your PHP file path
        type: 'GET',
        data: { id_number: idNumber },
        dataType: 'json',
        success: function(response) {
          console.log(response);
           var customer_id = response.id;

          if (!customer_id) {
              alert('Invalid ID Number.');
              $('#customer_name').val('');
              $('#customer_phone').val('');
              $('#customer_email').val('');
              $('#customer_address').val('');
              return;
          }else{
              $('#customer_name').val(response.name);
              $('#customer_phone').val(response.phone);
              $('#customer_email').val(response.email);
              $('#customer_address').val(response.address);
          }
          

        },
        error: function(xhr) {
            $('#customer_result').html('<p style="color:red;">Error fetching data.</p>');
            console.error('Error:', xhr.responseText);
        }
    });
});
</script>
<script>
  let selectedItem = {};

  $(function () {
    $("#item_name").autocomplete({
      source: function (request, response) {
        $.ajax({
          url: "search_items.php",
          type: "GET",
          dataType: "json",
          data: { term: request.term },
          success: function (data) {
            response(data);
          }
        });
      },
      minLength: 1,
      select: function (event, ui) {
        selectedItem = ui.item;
        console.log(ui.item.qty);
        $('#item_name').val(ui.item.label); 
        $('#item_qty').attr('max', ui.item.qty);
        return false;
      }
    });
  });
</script>

<script>
let rentalList = [];

$('#add_to_list_btn').on('click', function () {
  if (!selectedItem.id) {
    alert("Please select a valid item.");
    return;
  }

  const itemId = selectedItem.id;
  const itemName = selectedItem.label;
  const rentalPrice = parseFloat(selectedItem.price).toFixed(2);
  const estimatedDate = $('input[name="estimated_date"]').val();
  const itemCode = selectedItem.code;
  let qty = parseInt($("#item_qty").val());
  console.log(qty);
  console.log(itemCode);
  if (!itemCode || qty <= 0) {
      alert("Please select an item and enter valid qty.");
      return;
  }

  if (qty > selectedItem.qty) {
    alert(`Only ${selectedItem.qty} units available for this item.`);
    return;
  }

  if (!estimatedDate) {
    alert("Please select estimated date of delivery.");
    return;
  }
const dateString = document.querySelector('input[name="estimated_date"]').value;
const [year, month, day] = dateString.split('-').map(Number);

// Note: `month` is zero-based in JavaScript Date (0 = Jan, 6 = Jul)
const estDate = new Date(year, month - 1, day);
estDate.setHours(0, 0, 0, 0);

const today = new Date();

// Set both to midnight to avoid time difference issues
today.setHours(0, 0, 0, 0);

// Calculate difference in days and include both start and end
console.log(today.toString());
console.log(estDate.toString());

const diffTime = estDate.getTime() - today.getTime();
const diffDays = Math.floor(diffTime / (1000 * 60 * 60 * 24));

const rentalDays = diffDays + 1;

if (rentalDays < 1) {
  alert("Estimated delivery date must be today or later.");
  return;
}


  const total = (rentalPrice * rentalDays * qty).toFixed(2);
  const uniqueId = Date.now() + Math.random().toString(36).substring(2, 9);

  rentalList.push({
    unique_id: uniqueId,
    item_id: itemId,
    item_code: itemCode,
    itemQty:qty,
    item_name: itemName,
    price: rentalPrice,
    rental_days: rentalDays,
    estimated_date: estimatedDate,
    total: total
  });

  $('#rental_items').val(JSON.stringify(rentalList));

  const newRow = `
    <tr data-unique-id="${uniqueId}">
      <td>${itemId}</td>
      <td>${itemCode}</td>
      <td>${itemName}</td>
      <td>${qty}</td>
      <td>${rentalPrice}</td>
      <td>${estimatedDate}</td>
      <td>${rentalDays}</td>
      <td>${total}</td>
      <td><button type="button" class="btn btn-danger btn-sm remove-item">X</button></td>
    </tr>
  `;

  $('.table tbody').append(newRow);
  updateTotal();
  $('#item_name').val('');
  $('#item_qty').val(1);
  selectedItem = {};
});

function updateTotal() {
  let subtotal = 0;
  $('.table tbody tr').each(function () {
    const rowTotal = parseFloat($(this).find('td:eq(7)').text());
    subtotal += rowTotal;
  });

  let discount = parseFloat($('#discount').val()) || 0;
  let fee = parseFloat($('#additional_fee').val()) || 0;
  console.log(fee);

  const finalTotal = subtotal - discount + fee;
console.log(finalTotal);
  $('#subtotal_display').text(subtotal.toFixed(2));

  $('#final_total_display').text(finalTotal.toFixed(2));
  $('#total_amount').val(subtotal.toFixed(2));
  $('#final_total').val(finalTotal.toFixed(2));
  $('#discount_hidden').val(discount.toFixed(2));
  $('#additional_fee_hidden').val(fee.toFixed(2));
}



$(document).on('click', '.remove-item', function () {
  const row = $(this).closest('tr');
  const uniqueId = row.data('unique-id');

  rentalList = rentalList.filter(item => item.unique_id !== uniqueId);

  $('#rental_items').val(JSON.stringify(rentalList));

  row.remove();

  updateTotal();
});





</script>
<script>

// Show preview after selecting/capturing
document.getElementById("receiver_photo").addEventListener("change", function(event) {
  const file = event.target.files[0];
  if (file) {
    const reader = new FileReader();
    reader.onload = function(e) {
      const preview = document.getElementById("preview");
      preview.src = e.target.result;
      preview.style.display = "block";
    };
    reader.readAsDataURL(file);
  }
});
</script>
<script>
$('form').on('submit', function(e) {
    // Check customer data
    const customerName = $('#customer_name').val().trim();
    const customerPhone = $('#customer_phone').val().trim();
    const customerEmail = $('#customer_email').val().trim();
    const customerAddress = $('#customer_address').val().trim();

    if (!customerName || !customerPhone || !customerEmail || !customerAddress) {
        alert('Please fill all customer details.');
        e.preventDefault(); // Stop form submission
        return false;
    }

    // Check receiver data
    const receiverName = $('#receiver_name').val().trim();
    const receiverId = $('#receiver_id').val().trim();
    const receiverPhoto = $('input[name="receiver_photo"]').val();

    if (!receiverName || !receiverId || !receiverPhoto) {
        alert('Please fill all receiver details and upload photo.');
        e.preventDefault();
        return false;
    }

    // Check if at least one rental item is added
    if (rentalList.length === 0) {
        alert('Please add at least one rental item.');
        e.preventDefault();
        return false;
    }

   

    // All validations passed, form will submit
});
</script>

            <!-- / Content -->
<?php include 'footer.php'; ?>