<?php include 'header.php'; ?>
<?php
$db = new DB();

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $conn = $db->getConnection();

    $saleData = [
        'customer_id' => $_POST['customer_id'],
        'customer_phone' => $_POST['customer_phone'],
        'customer_email' => $_POST['customer_email'],
        'customer_address' => $_POST['customer_address'],
        'total' => $_POST['total_amount'],
        'pay_amount' => $_POST['pay_amount'],
        'transport_charge' => $_POST['transport_charge'], 
        'status' => 'Completed'
    ];

    $inserted = $db->insert('sales', $saleData);

    if ($inserted) {
        $saleId = $conn->insert_id;

        // Insert payment
        if ($_POST['pay_amount'] != '0') {
            
            $is_online_payment = isset($_POST['is_online_payment']) ? 1 : 0;

             
            $ref_number = $_POST['ref_number'] ?? null;
            
            if ($is_online_payment) {
                $note = "Initial Payment for Sale ID | $saleId";
                $is_online = "1";
                 date_default_timezone_set('Asia/Colombo');
                $startDatecustome = new DateTime();
                $mysqlDatecustom = $startDatecustome->format('Y-m-d H:i:s');
    
                $stmt = $conn->prepare("INSERT INTO payment (sales_id, sales_type, note, amount,online_payment,ref_id,date) VALUES (?, 'Sale', ?, ?, ?, ?, ?)");
                $stmt->bind_param("isdsss", $saleId, $note, $_POST['pay_amount'],$is_online,$ref_number,$mysqlDatecustom);
                $stmt->execute();
                $stmt->close();
            }else{
                $note = "Initial Payment for Sale ID | $saleId";
                $stmt = $conn->prepare("INSERT INTO payment (sales_id, sales_type, note, amount, date) VALUES (?, 'Sale', ?, ?, ?)");
                $stmt->bind_param("isds", $saleId, $note, $_POST['pay_amount'],$mysqlDatecustom);
                $stmt->execute();
                $stmt->close();
            }
    
            
        }

        // Handle sold items
        $saleItems = json_decode($_POST['sale_items'], true);
        foreach ($saleItems as $item) {
            $stmt = $conn->prepare("INSERT INTO sales_items_sold (sales_id, item_id, price, qty, total) VALUES (?, ?, ?, ?, ?)");
            $stmt->bind_param("iiddi", $saleId, $item['item_id'], $item['price'], $item['qty'], $item['total']);
            $stmt->execute();
            $stmt->close();

            // Update stock
            $updateStmt = $conn->prepare("INSERT INTO stock (item_id, stock_type, amount) VALUES (?, 'out', ?)");
            $negQty = -abs($item['qty']);
            $updateStmt->bind_param("id", $item['item_id'], $negQty);
            $updateStmt->execute();
            $updateStmt->close();
        }

echo "<script>window.location.href = 'print_sale.php?id=$saleId';</script>";
    } else {
        echo "<script>window.location.href = 'new_sale.php?error=Failed to add Sale';</script>";
    }
}
?>

<div class="content-wrapper">
    <div class="container-xxl flex-grow-1 container-p-y">
        <div class="card mt-4">
            <h5 class="card-header">New Sale</h5>
            <div class="card-body">
                <form method="POST">
                    <input type="hidden" name="sale_items" id="sale_items">
                    <input type="hidden" name="total_amount" id="total_amount">

                    <!-- Customer Details -->
                    <div class="row mb-4">
                        <div class="col-md-3">
                            <label>Customer ID (Scan or Enter)</label>
                            <input type="text" name="customer_id" id="id_number_input" class="form-control" >
                        </div>
                        <div class="col-md-2 d-flex align-items-end">
                            <button type="button" class="btn btn-primary" id="search_customer">Search</button>
                        </div>
                        <div class="col-md-3">
                            <label>Name</label>
                            <input type="text" name="customer_name" id="customer_name" class="form-control" readonly required>
                        </div>
                        <div class="col-md-2">
                            <label>Phone</label>
                            <input type="text" name="customer_phone" id="customer_phone" class="form-control" readonly required>
                        </div>
                        <div class="col-md-2">
                            <label>Email</label>
                            <input type="email" name="customer_email" id="customer_email" class="form-control" readonly required>
                        </div>
                        <div class="col-md-6 mt-3">
                            <label>Address</label>
                            <textarea name="customer_address" id="customer_address" class="form-control" readonly required></textarea>
                        </div>
                    </div>

                    <!-- Item Add Section -->
                    <div class="row mb-3">
                        <div class="col-md-6">
                            <label>Search Item</label>
                            <input type="text" id="item_name" class="form-control" placeholder="Type to search...">
                        </div>
                        <div class="col-md-3">
                            <label>Quantity</label>
                            <input type="number" id="item_qty" class="form-control" min="1" value="1">
                        </div>
                        <div class="col-md-3 d-flex align-items-end">
                            <button type="button" id="add_to_list_btn" class="btn btn-success w-100">Add Item</button>
                        </div>
                    </div>

                    <!-- Item Table -->
                    <table class="table">
                        <thead>
                            <tr>
                                <th>Item</th>
                                <th>Price</th>
                                <th>Qty</th>
                                <th>Total</th>
                                <th>Action</th>
                            </tr>
                        </thead>
                        <tbody class="table-border-bottom-0"></tbody>
                    </table>

                    <!-- Transport Charge -->
<div class="row mb-3">
    <div class="col-md-3">
        </br>
        <label>Transport Charge</label>
        <input type="number" name="transport_charge" id="transport_charge" value="0" min="0" step="0.01" class="form-control">
    </div>
</div>

<h5>Total: LKR. <span id="grand_total">0.00</span></h5>
<div class="">
  <div class="">
    <label class="form-label d-block">Is Online Payment</label>
    <input type="checkbox" id="is_online_payment" name="is_online_payment" value="1" />
  </div>

  <div class="" id="ref_number_box" style="display: none;">
    <label class="form-label">Reference Number</label>
    <input type="text" name="ref_number" id="ref_number" class="form-control" placeholder="Enter Reference Number" style="    width: 23%;
    margin-top: 0%;
    margin-bottom: 2%;">
  </div>
 </div>

                    <!-- Payment -->
                    <div class="row mb-4">
                        <div class="col-md-3">
                            <label>Paid Amount</label>
                            <input type="number" name="pay_amount" id="pay_amount" value="0" min="0" step="0.01" class="form-control">
                        </div>
                    </div>

                    <button type="submit" class="btn btn-primary w-100">Submit Sale</button>
                </form>
            </div>
        </div>
    </div>
</div>

<!-- Scripts -->
<script>
let selectedItem = {};
let saleList = [];

$(function () {
    $("#item_name").autocomplete({
        source: function (request, response) {
            $.ajax({
                url: "search_sales_items.php",
                type: "GET",
                data: { term: request.term },
                dataType: "json",
                success: function (data) {
                    response(data);
                }
            });
        },
        select: function (event, ui) {
            selectedItem = ui.item;
            $('#item_name').val(ui.item.label);
            return false;
        }
    });
});

$('#add_to_list_btn').on('click', function () {
    const qty = parseFloat($('#item_qty').val());
    if (!selectedItem.id || qty <= 0 || qty > selectedItem.stock) {
        alert("Invalid quantity or item.");
        return;
    }

    const total = (qty * selectedItem.price).toFixed(2);
    const uniqueId = Date.now() + Math.random().toString(36).substring(2, 9);

    saleList.push({
        unique_id: uniqueId,
        item_id: selectedItem.id,
        item_name: selectedItem.label,
        price: selectedItem.price,
        qty: qty,
        total: total
    });

    $('#sale_items').val(JSON.stringify(saleList));

    const row = `
      <tr data-unique-id="${uniqueId}">
        <td>${selectedItem.label}</td>
        <td>${selectedItem.price}</td>
        <td>${qty}</td>
        <td>${total}</td>
        <td><button type="button" class="btn btn-danger btn-sm remove-item">Remove</button></td>
      </tr>
    `;

    $('.table tbody').append(row);
    updateTotal();
    $('#item_name').val('');
    $('#item_qty').val(1);
    selectedItem = {};
});

$(document).on('click', '.remove-item', function () {
    const row = $(this).closest('tr');
    const id = row.data('unique-id');
    row.remove();
    saleList = saleList.filter(item => item.unique_id !== id);
    $('#sale_items').val(JSON.stringify(saleList));
    updateTotal();
});


$('#transport_charge').on('input', function () {
    updateTotal();
});


function updateTotal() {
    let total = saleList.reduce((sum, item) => sum + parseFloat(item.total), 0);

    // Include transport charge
    let transport = parseFloat($('#transport_charge').val()) || 0;
    total += transport;

    $('#grand_total').text(total.toFixed(2));
    $('#total_amount').val(total.toFixed(2));

    // Set max attribute of pay_amount input
    $('#pay_amount').attr('max', total.toFixed(2));

    // Auto-correct if entered value > total
    let paid = parseFloat($('#pay_amount').val());
    if (paid > total) {
        $('#pay_amount').val(total.toFixed(2));
    }
}



// Customer AJAX fetch
$('#search_customer').on('click', function () {
    let id = $('#id_number_input').val();
    if (!id) return alert("Enter Customer ID.");

    $.getJSON("customer_search_ajax.php", { id_number: id }, function (res) {
        if (res.id) {
            $('#customer_name').val(res.name);
            $('#customer_phone').val(res.phone);
            $('#customer_email').val(res.email);
            $('#customer_address').val(res.address);
        } else {
            alert("Customer not found.");
        }
    });
});


</script>
<script>
document.getElementById('is_online_payment').addEventListener('change', function() {
    const refBox = document.getElementById('ref_number_box');
    if (this.checked) {
        refBox.style.display = 'block';
    } else {
        refBox.style.display = 'none';
        document.getElementById('ref_number').value = ''; // clear value when unchecked
    }
});
</script>

<?php include 'footer.php'; ?>
