<?php
include 'header.php';
$db = new DB();
$conn = $db->getConnection();

// Fetch payment records
$query = "
    SELECT p.category,p.id, p.sales_id, p.sales_type, p.note, p.amount, p.date, c.name AS customer_name
    FROM payment p
    LEFT JOIN sales s ON p.sales_id = s.id
    LEFT JOIN customers c ON s.customer_id = c.id_number
    ORDER BY p.date DESC
";
$result = $conn->query($query);
$catRes = $conn->query("SELECT * FROM payment_categories ORDER BY name ASC");

// Totals
$totalIn = 0;
$totalOut = 0;

if (isset($_POST['submit_payment'])) {
    $salesType = $_POST['sales_type'] ?? null;
    $salesId = $_POST['sales_id'] ?? null;
    $type = $_POST['type']; // 'in' or 'out'
    $amount = floatval($_POST['amount']);
    $note = $_POST['note'];
    $category = $_POST['category'];
    $date = date('Y-m-d H:i:s');

    // Make amount negative for "out"
    if ($type === 'out') {
        $amount = -1 * abs($amount);
    }
    date_default_timezone_set('Asia/Colombo'); 
    $startDatecustome = new DateTime();
    $mysqlDatecustom = $startDatecustome->format('Y-m-d H:i:s');
    // Insert into payment table
    $stmt = $conn->prepare("INSERT INTO payment (sales_id, sales_type, note, amount, date,category) VALUES (?, ?, ?, ?, ?, ?)");
    $stmt->bind_param("issdss", $salesId, $salesType, $note, $amount, $mysqlDatecustom,$category);
    $stmt->execute();
    $stmt->close();

    echo "<script>window.location.href = 'payment_list.php?success=Success! New Payment Recode Added.';</script>";
    exit;
}

?>

<div class="content-wrapper">
  <div class="container-xxl flex-grow-1 container-p-y">
    <h4>Payment Managment</h4>
<!-- Payment Entry Form -->
<div class="card mb-4">
  <div class="card-header">
    <strong>Add Payment Entry</strong>
  </div>
  <div class="card-body">
    <form method="POST" action="">
      <div class="row">
       <input type="hidden" name="sales_type" value="System">
       <input type="hidden" name="sales_id" value="System">

       

        <div class="col-md-3">
          <label for="type" class="form-label">Payment Type</label>
          <select name="type" id="type" class="form-control" required>
            <option value="in">Payment In</option>
            <option value="out">Payment Out</option>
          </select>
        </div>

        <div class="col-md-3">
          <label for="amount" class="form-label">Amount (LKR)</label>
          <input type="number" step="0.01" name="amount" id="amount" class="form-control" required>
        </div>
       <div class="col-md-3">
  <label class="form-label">Category</label>
  <div class="input-group">
    <select name="category" id="categorySelect" class="form-control" required>
      <option value="">-- Select --</option>
      <?php while($cat = $catRes->fetch_assoc()): ?>
        <option value="<?= htmlspecialchars($cat['name']) ?>">
          <?= htmlspecialchars($cat['name']) ?>
        </option>
      <?php endwhile; ?>
    </select>
    <button type="button" class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#addCategoryModal">
      +
    </button>
  </div>
</div>


        <div class="col-md-3">
          <label for="note" class="form-label">Note</label>
          <textarea name="note" class="form-control" required></textarea>
        </div>

        <div class="col-md-6 mt-3 d-flex align-items-end">
          <button type="submit" name="submit_payment" class="btn btn-success">Add Payment</button>
        </div>
      </div>
    </form>
  </div>
</div>

    <div class="card">
      <div class="table-responsive">
        <table class="table table-bordered" id="paymentTable">
          <thead>
            <tr>
              <th>Payment ID</th>
              <th>Sale ID</th>
              <th>Note</th>
              <th>Amount (LKR)</th>
              <th>Type</th>
              <th>Category</th>
              <th>Date</th>
            </tr>
          </thead>
          <tbody>
            <?php if ($result->num_rows === 0): ?>
              <tr>
                <td colspan="6" class="text-center">No payments found.</td>
              </tr>
            <?php else: ?>
              <?php while ($row = $result->fetch_assoc()): ?>
                <?php
                  $amount = floatval($row['amount']);
                  if ($amount >= 0) {
                      $totalIn += $amount;
                  } else {
                      $totalOut += abs($amount); // Use absolute value for display
                  }
                ?>
                <tr>
                  <td><?= htmlspecialchars($row['id']) ?></td>
                  <td>
                    <?php if ($row['sales_type'] === 'Sale' && $row['sales_id']): ?>
                      <a href="view_sale.php?id=<?= $row['sales_id'] ?>">
                        <?= htmlspecialchars($row['sales_id']) ?>
                      </a>
                    <?php elseif ($row['sales_type'] === 'Rental' && $row['sales_id']): ?>
                      <a href="view_rental.php?id=<?= $row['sales_id'] ?>">
                        <?= htmlspecialchars($row['sales_id']) ?>
                      </a>
                    <?php else: ?>
                      -
                    <?php endif; ?>
                  </td>
                  <td><?= htmlspecialchars($row['note']) ?></td>
                  <td><?= number_format($amount, 2) ?></td>
                  <td><?= htmlspecialchars($row['sales_type']) ?></td>
                  <td><?= $row['category'] ?></td>
                  <td><?= htmlspecialchars(date('Y-m-d', strtotime($row['date']))) ?></td>
                </tr>
              <?php endwhile; ?>
            <?php endif; ?>
          </tbody>
        </table>
      </div>

      <!-- Totals Section -->
      <div class="card-footer">
        <div class="row">
          <div class="col-md-4">
            <strong>Total In:</strong> LKR <?= number_format($totalIn, 2) ?>
          </div>
          <div class="col-md-4">
            <strong>Total Out:</strong> LKR <?= number_format($totalOut, 2) ?>
          </div>
          <div class="col-md-4">
            <strong>Net Total:</strong> LKR <?= number_format($totalIn - $totalOut, 2) ?>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>
<div class="modal fade" id="addCategoryModal" tabindex="-1">
  <div class="modal-dialog modal-dialog-centered">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title">Add New Category</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
      </div>

      <div class="modal-body">
        <input type="text" id="newCategoryName" class="form-control" placeholder="Category name">
      </div>

      <div class="modal-footer">
        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
        <button type="button" class="btn btn-success" id="saveCategoryBtn">Save</button>
      </div>
    </div>
  </div>
</div>

<script>
  $(document).ready(function() {
    $('#paymentTable').DataTable();
  });
</script>

<?php include 'footer.php'; ?>
