<?php
// Show all errors
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

include 'db.php';

$db = new DB();
$conn = $db->getConnection();

$saleId = intval($_GET['id']);

// Fetch sale with pay_amount
$saleQuery = "
    SELECT s.id, s.date_added, s.pay_amount,s.transport_charge, 
           c.name AS customer_name, c.phone, c.address
    FROM sales s
    LEFT JOIN customers c ON s.customer_id = c.id_number
    WHERE s.id = ?
";
$stmt = $conn->prepare($saleQuery);
$stmt->bind_param("i", $saleId);
$stmt->execute();
$sale = $stmt->get_result()->fetch_assoc();
$stmt->close();

// Fetch sale items
$itemQuery = "
    SELECT si.price, si.qty, si.total, i.name
    FROM sales_items_sold si
    LEFT JOIN sales_items i ON si.item_id = i.id
    WHERE si.sales_id = ?
";
$stmt = $conn->prepare($itemQuery);
$stmt->bind_param("i", $saleId);
$stmt->execute();
$items = $stmt->get_result();
$stmt->close();
?>

<style>
body {
    font-family: monospace;
    width: 80mm;
    margin: 0;
}
.receipt {
    padding: 5px;
}
.text-center { text-align: center; }
.text-right { text-align: right; }
hr { border: none; border-top: 1px dashed #000; }
</style>

<div class="receipt">
 
      <h4 class="text-center" style="text-align:center;margin-bottom: 0;">CHANDANA ENGINEERING & CONSTRUCTION</h4>
  <p class="text-center" style="text-align:center;font-size: 10px;">Vijithapura, Badullaroad, Magastota, Nuwaraeliya<br>052-4316 968 | 077 566 5007 | 071 79799304<br>chandanaengineering1975@gmail.com</p>
    <hr>
    <p>Invoice: <?= $sale['id'] ?><br>
    Date: <?= date('Y-m-d H:i', strtotime($sale['date_added'])) ?><br>
    Customer: <?= !empty($sale['customer_name']) ? htmlspecialchars($sale['customer_name']) : 'N/A' ?></p>
    <hr>
    <table width="100%">
        <?php while($row = $items->fetch_assoc()): ?>
        <tr>
            <td><?= htmlspecialchars($row['name']) ?> Rs.<?= number_format($row['price'], 2) ?> x<?= $row['qty'] ?></td>
            <td class="text-right">Rs.<?= number_format($row['total'], 2) ?></td>
        </tr>
        <?php endwhile; ?>
    </table>
    <hr>
    <?php
    $totalQuery = "SELECT SUM(total) AS grand_total FROM sales_items_sold WHERE sales_id = ?";
    $stmt = $conn->prepare($totalQuery);
    $stmt->bind_param("i", $saleId);
    $stmt->execute();
    $total = $stmt->get_result()->fetch_assoc()['grand_total'];
    $stmt->close();
    ?>
<?php
$net_total = $total + $sale['transport_charge'];
?>
<p class="text-right"><strong>Item Total: <?= number_format($total, 2) ?></strong></p>
<p class="text-right"><strong>Transport Charge: <?= number_format($sale['transport_charge'], 2) ?></strong></p>
<p class="text-right"><strong>Net Total: <?= number_format($net_total, 2) ?></strong></p>

    <p class="text-right"><strong>Paid: <?= number_format($sale['pay_amount'], 2) ?></strong></p>
    <p class="text-right"><strong>Balance: <?= number_format($net_total - $sale['pay_amount'], 2) ?></strong></p>
    <hr>
    <p class="text-center">Thank you for your purchase!</p>
</div>

<script>
    window.print();
    setTimeout(() => {
        window.location.href = "sales_list.php";
    }, 1000);
</script>
