<?php
include 'header.php'; // Your DB connection class


$db = new DB();
$conn = $db->getConnection();

$user_email = $_SESSION['user_email'];
$message = '';

// Fetch current user data
$stmt = $conn->prepare("SELECT name FROM users WHERE email = ?");
$stmt->bind_param("s", $user_email);
$stmt->execute();
$result = $stmt->get_result();
if ($result->num_rows === 0) {
    echo "User not found";
    exit;
}
$user = $result->fetch_assoc();

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $new_name = trim($_POST['name']);
    $new_password = trim($_POST['password']);
    $confirm_password = trim($_POST['confirm_password']);

    if (empty($new_name)) {
        $message = "Name cannot be empty.";
    } else if (!empty($new_password) && $new_password !== $confirm_password) {
        $message = "Passwords do not match.";
    } else {
        // Update query
        if (!empty($new_password)) {
            // Hash the new password
            $hashed_password = password_hash($new_password, PASSWORD_DEFAULT);
            $update_stmt = $conn->prepare("UPDATE users SET name = ?, password = ? WHERE email = ?");
            $update_stmt->bind_param("sss", $new_name, $hashed_password, $user_email);
        } else {
            // Only update name
            $update_stmt = $conn->prepare("UPDATE users SET name = ? WHERE email = ?");
            $update_stmt->bind_param("ss", $new_name, $user_email);
        }

        if ($update_stmt->execute()) {
            $message = "Profile updated successfully.";
            $user['name'] = $new_name; // update current name for form
        } else {
            $message = "Failed to update profile.";
        }
    }
}

?>
<div class="card" style="margin-left:3%;margin-right: 3%;margin-top: 3%;padding:3%;">
    <h4>Update Profile</h4>

    <?php if ($message): ?>
        <p style="color:<?= strpos($message, 'successfully') !== false ? 'green' : 'red' ?>"><?= htmlspecialchars($message) ?></p>
    <?php endif; ?>

    <form method="POST" action="profile.php">
        <label style="width:100%;">
            Name:<br />
            <input style="width:100%;" class="form-control" type="text" name="name" value="<?= htmlspecialchars($user['name']) ?>" required />
        </label>
        <br /><br />
        <label style="width:100%;">
            New Password:<br />
            <input style="width:100%;" class="form-control" type="password" name="password" placeholder="Leave blank to keep current password" />
        </label>
        <br /><br />
        <label style="width:100%;">
            Confirm Password:<br />
            <input style="width:100%;" class="form-control" type="password" name="confirm_password" placeholder="Confirm new password" />
        </label>
        <br /><br />
        <button style="width:100%;" class="btn btn-primary" type="submit">Update</button>
    </form>

</div>

<?php include 'footer.php'; ?>
