<?php include 'header.php'; ?>
<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

$db = new DB();
$conn = $db->getConnection();

if (isset($_POST['mark_recived'])) {
    $photoPath = '';
$rentalId   = (int) $_POST['rental_id'];
$recived_id = (int) $_POST['recived_id']; // Correct ID to use in WHERE
$item_id    = (int) $_POST['item_id'];
$total      = (float) $_POST['total'];
$duration   = (int) $_POST['duration'];
$end_date   = $_POST['end_date']; // Assume it's a valid date string (Y-m-d H:i:s or similar)
$qty   = (int) $_POST['qty'];
// Handle image upload
if (isset($_FILES['recevier_img']) && $_FILES['recevier_img']['error'] === 0) {
    $uploadDir = 'uploads/item_recived/';
    if (!is_dir($uploadDir)) {
        mkdir($uploadDir, 0755, true);
    }

    $filename = basename($_FILES['recevier_img']['name']);
    $targetFile = $uploadDir . time() . "_" . $filename;

    if (move_uploaded_file($_FILES['recevier_img']['tmp_name'], $targetFile)) {
        $photoPath = $targetFile;
    } else {
        echo "<div class='alert alert-danger'>Photo upload failed.</div>";
        exit;
    }
}

// Now update the DB
$updateStmt = $conn->prepare("
    UPDATE rental_items_issuse 
    SET rental_days = ?, total = ?, status = 'Recived', reciver_photo = ?, r_date = ? 
    WHERE id = ?
");

if ($updateStmt) {
    $updateStmt->bind_param("idssi", $duration, $total, $photoPath, $end_date, $recived_id);
    if ($updateStmt->execute()) {

        $updateStmt->close();
        $total = 0;
        $sumStmt = $conn->prepare("SELECT SUM(total) FROM rental_items_issuse WHERE rental_id = ?");
        $sumStmt->bind_param("i", $rentalId);
        $sumStmt->execute();
        $sumStmt->bind_result($total);
        $sumStmt->fetch();
        $sumStmt->close();
        // Step 2: Get discount and additional from rental table
        $discount = 0;
        $additional = 0;
        $adjStmt = $conn->prepare("SELECT discount, additional FROM rental WHERE id = ?");
        $adjStmt->bind_param("i", $rentalId);
        $adjStmt->execute();
        $adjStmt->bind_result($discount, $additional);
        $adjStmt->fetch();
        $adjStmt->close();

        // Step 3: Calculate new total: subtotal - discount + additional
        $sub_total_u = $total;
        $total = ($sub_total_u + $additional) - $discount;

        $updateRental = $conn->prepare("UPDATE rental SET total = ?,subtotal = ?,discount = ?,additional = ? WHERE id = ?");
        $updateRental->bind_param("sssss", $total,$sub_total_u,$discount,$additional,$rentalId);
        $updateRental->execute();
        $updateRental->close();
        $updateStmts = $conn->prepare("UPDATE rental_items SET qty = qty + ? WHERE id = ?");
        $updateStmts->bind_param("ii", $qty, $item_id);
        $updateStmts->execute();
        $updateStmts->close();


        $totalStmt = $conn->prepare("SELECT COUNT(*) FROM rental_items_issuse WHERE rental_id = ?");
        $totalStmt->bind_param("i", $rentalId);
        $totalStmt->execute();
        $totalStmt->bind_result($totalCount);
        $totalStmt->fetch();
        $totalStmt->close();

        // 2. Count only 'Recived' items for this rental
        $recivedStmt = $conn->prepare("SELECT COUNT(*) FROM rental_items_issuse WHERE rental_id = ? AND status = 'Recived'");
        $recivedStmt->bind_param("i", $rentalId);
        $recivedStmt->execute();
        $recivedStmt->bind_result($recivedCount);
        $recivedStmt->fetch();
        $recivedStmt->close();
        
        echo "<script>window.location.href = 'view_rental.php?success=Rental updated successfully&id=$rentalId';</script>";

    } else {
        echo "<div class='alert alert-danger'>Execution failed: " . $updateStmt->error . "</div>";
        $updateStmt->close();
    }
    
} else {
    echo "<div class='alert alert-danger'>Prepare failed: " . $conn->error . "</div>";
}



}else{
    $rentalId = (int) $_GET['rental_id'];
    $recived_id = (int) $_GET['recived_id'];
    $item_id = (int) $_GET['item_id'];
    $stmt = $conn->prepare("SELECT c_date,price,qty FROM rental_items_issuse WHERE id = ?");
    $stmt->bind_param("i", $recived_id);
    $stmt->execute();
    $stmt->bind_result($cDate,$price,$qty);
    $stmt->fetch();
    $stmt->close();

    $startDate = new DateTime($cDate);
    date_default_timezone_set('Asia/Colombo');
    $endDate = new DateTime();

    $currentHour = (int)$endDate->format('H'); // Get the current hour in 24-hour format
    $ex = 0;
    if ($currentHour >= 9) { // 21 means 9 PM
      $ex = 1;
    } else {

    }
    $startDatecal = new DateTime($cDate);
    $startDatecal->setTime(0, 0, 0);

    $endDatecal = new DateTime();
    $endDatecal->setTime(0, 0, 0);
    
    $rentalDays = $startDatecal->diff($endDatecal)->days;
    if ($rentalDays == "0") {
      $rentalDays = "1";
    }
    if ($startDatecal == $endDatecal) {
      $rentalDays = "1";
    }else{
      $rentalDays = $rentalDays+$ex;
    }
    
    $startDateStr = $startDate->format('Y-m-d H:i:s');
    $endDateStr = $endDate->format('Y-m-d H:i:s');
   
    $new_total = $rentalDays * $price * $qty; // keep as float

}
    

?>



    <div class="content-wrapper">
  <div class="container-xxl flex-grow-1 container-p-y">
    <div class="card" style="margin-top: 2%;padding-top:2%;padding-right: 2%;padding-left: 2%;padding-bottom: 3%;">
      
        <h5>Mark Recived Note</h5>
       

  <form method="POST" action="recived_item.php" enctype="multipart/form-data">
    <input type="hidden" name="rental_id" value="<?= $rentalId ?>">
        <input type="hidden" name="recived_id" value="<?= $recived_id ?>">
    <input type="hidden" name="item_id" value="<?= $item_id ?>">
    <input type="hidden" name="total" value="<?= $new_total ?>">
        <input type="hidden" name="duration" value="<?= $rentalDays ?>">
        <input type="hidden" name="end_date" value="<?= $endDateStr ?>">
        <input type="hidden" name="qty" value="<?= $qty ?>">
<div class="row">
  <div class="col-lg-6">

  <div class="form-group">
    <label>Receiver Image</label>
    <input type="file" id="recevier_img" name="recevier_img" class="form-control" accept="image/*" capture="environment" required>
    
<button type="button" class="btn btn-primary mt-2" onclick="openCamera()">Capture by Camera</button>
  
  <!-- Preview -->
  <img id="preview" src="" alt="Preview" style="width:100%;margin-top:10px;display:none;border:1px solid #ccc;padding:4px;border-radius:8px;">
  </div>

    <div class="form-group">
    <input type="submit" name="mark_recived" value="Mark Item Is Recived ?" class="btn btn-primary" style="margin-top:2%;">
  </div>
  </div>
  
  <div class="col-lg-6">
    <p>Issuse Date : <?= $startDateStr ?></p>
    <p>Recived Date : <?= $endDateStr ?></p>
<p>Duration : <?= $rentalDays ?></p>
<p>Qty : <?= $qty ?></p>
<p>Charge : <?= $qty ?> * <?= $rentalDays ?> * <?= $price ?> = LKR.<?= number_format($new_total, 2) ?></p>
  </div>
  </div>
  </form>



     
          
         
            
      
    </div>
  </div>
</div>

<!-- Webcam Modal -->
<div class="modal fade" id="cameraModal" tabindex="-1" aria-labelledby="cameraModalLabel" aria-hidden="true">
  <div class="modal-dialog modal-dialog-centered modal-lg">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title">Capture Receiver Photo</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close" onclick="closeWebcam()"></button>
      </div>
      <div class="modal-body text-center">
        <video id="cameraStream" autoplay playsinline style="width:100%;border-radius:8px;"></video>
        <canvas id="captureCanvas" style="display:none;"></canvas>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-success" onclick="takeSnapshot()">📸 Capture</button>
        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal" onclick="closeWebcam()">Close</button>
      </div>
    </div>
  </div>
</div>
<script>
let stream;

function openCamera() {
  navigator.mediaDevices.getUserMedia({ video: true })
    .then(s => {
      stream = s;
      document.getElementById("cameraStream").srcObject = s;
      var modal = new bootstrap.Modal(document.getElementById("cameraModal"));
      modal.show();
    })
    .catch(err => {
      alert("Camera not accessible: " + err);
    });
}

function takeSnapshot() {
  const video = document.getElementById("cameraStream");
  const canvas = document.getElementById("captureCanvas");
  const context = canvas.getContext("2d");
  canvas.width = video.videoWidth;
  canvas.height = video.videoHeight;
  context.drawImage(video, 0, 0, canvas.width, canvas.height);

  // Convert to blob & assign to file input
  canvas.toBlob(function(blob) {
    let file = new File([blob], "receiver_photo.png", { type: "image/png" });
    let dataTransfer = new DataTransfer();
    dataTransfer.items.add(file);
    document.getElementById("recevier_img").files = dataTransfer.files;

    // Show preview
    const preview = document.getElementById("preview");
    preview.src = URL.createObjectURL(blob);
    preview.style.display = "block";
  }, "image/png");

  closeWebcam();
}

function closeWebcam() {
  if (stream) {
    stream.getTracks().forEach(track => track.stop());
  }
}
</script>


<script>


// Preview after selecting/capturing
document.getElementById("recevier_img").addEventListener("change", function(event) {
  const file = event.target.files[0];
  if (file) {
    const reader = new FileReader();
    reader.onload = function(e) {
      const preview = document.getElementById("preview");
      preview.src = e.target.result;
      preview.style.display = "block";
    };
    reader.readAsDataURL(file);
  }
});
</script>

<script>
document.getElementById('same_as_customer_btn').addEventListener('click', function () {
  let cus_name = $('#customer_name').val();
  let idNumber = $('#id_number_input').val();
  $('#receiver_name').val(cus_name);
  $('#receiver_id').val(idNumber);
});
</script>
<script>
$('#search_customer').on('click', function() {
    var idNumber = $('#id_number_input').val();

    if (!idNumber) {
        alert('Please enter an ID number.');
        return;
    }

    $.ajax({
        url: 'customer_search_ajax.php', // Change this to your PHP file path
        type: 'GET',
        data: { id_number: idNumber },
        dataType: 'json',
        success: function(response) {
          console.log(response);
           var customer_id = response.id;

          if (!customer_id) {
              alert('Invalid ID Number.');
              $('#customer_name').val('');
              $('#customer_phone').val('');
              $('#customer_email').val('');
              $('#customer_address').val('');
              return;
          }else{
              $('#customer_name').val(response.name);
              $('#customer_phone').val(response.phone);
              $('#customer_email').val(response.email);
              $('#customer_address').val(response.address);
          }
          

        },
        error: function(xhr) {
            $('#customer_result').html('<p style="color:red;">Error fetching data.</p>');
            console.error('Error:', xhr.responseText);
        }
    });
});
</script>
<script>
  let selectedItem = {};

  $(function () {
    $("#item_name").autocomplete({
      source: function (request, response) {
        $.ajax({
          url: "search_items.php",
          type: "GET",
          dataType: "json",
          data: { term: request.term },
          success: function (data) {
            response(data);
          }
        });
      },
      minLength: 2,
      select: function (event, ui) {
        selectedItem = ui.item;
        $('#item_name').val(ui.item.label); // Fill name in input
        return false;
      }
    });
  });
</script>

<script>
let rentalList = [];

$('#add_to_list_btn').on('click', function () {
  if (!selectedItem.id) {
    alert("Please select a valid item.");
    return;
  }

  const itemId = selectedItem.id;
  const itemName = selectedItem.label;
  const rentalPrice = parseFloat(selectedItem.price).toFixed(2);
  const estimatedDate = $('input[name="estimated_date"]').val();

  if (!estimatedDate) {
    alert("Please select estimated date of delivery.");
    return;
  }

  const today = new Date();
  const estDate = new Date(estimatedDate);
  today.setHours(0,0,0,0);
  estDate.setHours(0,0,0,0);

  const diffTime = estDate.getTime() - today.getTime();
  const rentalDays = Math.ceil(diffTime / (1000 * 60 * 60 * 24));

  if (rentalDays < 1) {
    alert("Estimated delivery date must be after today.");
    return;
  }

  const total = (rentalPrice * rentalDays).toFixed(2);

  rentalList.push({
    item_id: itemId,
    item_name: itemName,
    price: rentalPrice,
    rental_days: rentalDays,
    estimated_date: estimatedDate,
    total: total
  });

  $('#rental_items').val(JSON.stringify(rentalList));

  const newRow = `
    <tr>
      <td>${itemId}</td>
      <td>${itemName}</td>
      <td>${rentalPrice}</td>
      <td>${estimatedDate}</td>
      <td>${rentalDays}</td>
      <td>${total}</td>
      <td><button type="button" class="btn btn-danger btn-sm remove-item">X</button></td>
    </tr>
  `;

  $('.table tbody').append(newRow);
  updateTotal();
  $('#item_name').val('');
  selectedItem = {};
});

function updateTotal() {
  let total = 0;
  $('.table tbody tr').each(function () {
    const rowTotal = parseFloat($(this).find('td:eq(5)').text());
    total += rowTotal;
  });

  $('span:contains("Total : LKR.")').html(`Total : LKR. ${total.toFixed(2)}`);
  $('#total_amount').val(total.toFixed(2));
}


// Handle removing item
$(document).on('click', '.remove-item', function () {
  const row = $(this).closest('tr');
  const itemId = row.find('td:eq(0)').text();

  // Remove from rentalList array
  rentalList = rentalList.filter(item => item.item_id !== itemId);

  // Update hidden input
  $('#rental_items').val(JSON.stringify(rentalList));

  // Remove row from table
  row.remove();

  // Recalculate total
  updateTotal();
});




</script>
            <!-- / Content -->
<?php include 'footer.php'; ?>