<?php include 'header.php'; ?>
<?php
if (isset($_POST['update_stock'])) {
    $item_id = $_POST['item_id'];
    $stock_type = $_POST['stock_type'];
    $amount = floatval($_POST['stock_amount']);

    if ($amount <= 0) {
        echo "<script>window.location.href = 'sales_item_stock.php?error=Invalid amount. Must be greater than 0.'</script>";
        exit;
    }

    $DB = new DB();

    // Get current stock for the item
    $stockQty = $DB->selectSumStock($item_id);
    $currentStock = $stockQty['total'] ?? 0;

    // Check if stock out exceeds current stock
    if ($stock_type === 'out') {
        if ($amount > $currentStock) {
            echo "<script>window.location.href = 'sales_item_stock.php?error=Cannot stock out more than available. Available: " . number_format($currentStock, 2) . "';</script>";
            exit;
        }
        $amount = -abs($amount); // Make sure amount is negative for stock out
    }

    $insert = $DB->insert('stock', [
        'item_id' => $item_id,
        'stock_type' => $stock_type,
        'amount' => $amount
    ]);

    if ($insert) {
        echo "<script>window.location.href = 'sales_item_stock.php?success=Stock updated successfully.'</script>";
    } else {
        echo "<script>window.location.href = 'sales_item_stock.php?error=Failed to update stock.'</script>";
    }
}

?>
     <!-- Content wrapper -->
          <div class="content-wrapper">
            <!-- Content -->
            <div class="container-xxl flex-grow-1 container-p-y">
            	<div class="card">

              <div class="row" style="  
    padding-top: 1%;
    padding-bottom: 1%;
    align-items: baseline;
    padding-left: 1%;
    border-radius: 8px;padding-right: 1%;">

              	<div class="col-lg-6">
              		<span style="font-weight: 800;font-size: 18px;color: black;">Sales Items Stock Managment</span>
              	</div>
              	<div class="col-lg-6" style="align-content: stretch;
    display: flex
;
    flex-wrap: wrap;
    flex-direction: row;
    justify-content: flex-end;">
              			

                     


                          </div>
                        </div>
</div>

<?php
  $db = new DB();
  $itemsList = $db->selectAll('sales_items', '*', "status = 'Active'");
?>

<div class="card mt-4">
  <div class="card-body">
    <div class="row">
      <!-- Stock In Form -->
      <div class="col-md-6">
        <h5>Stock In</h5>
        <form method="POST" action="sales_item_stock.php">
          <div class="mb-3">
            <label class="form-label">Select Item</label>
            <select name="item_id" class="form-select" required>
              <option value="" disabled selected>Select an item</option>
              <?php foreach ($itemsList as $item): ?>
                <option value="<?php echo $item['id']; ?>"><?php echo htmlspecialchars($item['name']); ?></option>
              <?php endforeach; ?>
            </select>
          </div>
          <div class="mb-3">
            <label class="form-label">Amount</label>
            <input type="number" name="stock_amount" step="0.01" class="form-control" placeholder="Enter quantity" required>
          </div>
          <input type="hidden" name="stock_type" value="in">
          <button type="submit" name="update_stock" class="btn btn-success">Add Stock In</button>
        </form>
      </div>

      <!-- Stock Out Form -->
      <div class="col-md-6">
        <h5>Stock Out</h5>
        <form method="POST" action="sales_item_stock.php">
          <div class="mb-3">
            <label class="form-label">Select Item</label>
            <select name="item_id" class="form-select" required>
              <option value="" disabled selected>Select an item</option>
              <?php foreach ($itemsList as $item): ?>
                <option value="<?php echo $item['id']; ?>"><?php echo htmlspecialchars($item['name']); ?></option>
              <?php endforeach; ?>
            </select>
          </div>
          <div class="mb-3">
            <label class="form-label">Amount</label>
            <input type="number" name="stock_amount" step="0.01" class="form-control" placeholder="Enter quantity" required>
          </div>
          <input type="hidden" name="stock_type" value="out">
          <button type="submit" name="update_stock" class="btn btn-danger">Add Stock Out</button>
        </form>
      </div>
    </div>
  </div>
</div>

<div class="card" style="margin-top: 2%;">
    <div class="card-header">
        <form method="GET" action="sales_item_stock.php" class="row g-2">
            <div class="col-md-4">
                <input type="text" name="item_name" class="form-control"
                       placeholder="Search by Item Name"
                       value="<?php echo isset($_GET['item_name']) ? htmlspecialchars($_GET['item_name']) : ''; ?>">
            </div>

            <div class="col-md-3">
                <select name="stock_filter" class="form-control">
                    <option value="">All Stock</option>
                    <option value="out" <?php echo (isset($_GET['stock_filter']) && $_GET['stock_filter'] === 'out') ? 'selected' : ''; ?>>
                        Out of Stock
                    </option>
                    <option value="in" <?php echo (isset($_GET['stock_filter']) && $_GET['stock_filter'] === 'in') ? 'selected' : ''; ?>>
                        In Stock
                    </option>
                </select>
            </div>

            <div class="col-md-3">
                <select name="status" class="form-control">
                    <option value="">All Status</option>
                    <option value="Active" <?php echo (isset($_GET['status']) && $_GET['status'] === 'Active') ? 'selected' : ''; ?>>
                        Active
                    </option>
                    <option value="Deactivated" <?php echo (isset($_GET['status']) && $_GET['status'] === 'Deactivated') ? 'selected' : ''; ?>>
                        Deactivated
                    </option>
                </select>
            </div>

            <div class="col-md-2">
                <button type="submit" class="btn btn-primary w-100">Filter</button>
            </div>
        </form>
    </div>
</div>
                      <div class="card" style="margin-top: 2%;">
                <h5 class="card-header">Sales Items</h5>
                <div class="table-responsive text-nowrap">
                  <table class="table">
                    <thead>
                      <tr>
                        <th>Item ID</th>
                        <th>Item Name</th>
                        <th>Price</th>
                        <th>Stock</th>
                        <th>Status</th>
                        <th>Date Added</th>
                      </tr>
                    </thead>
                    <tbody class="table-border-bottom-0">
                    	<?php
                    		$db = new DB();
							$db = new DB();
$where = [];
$params = [];

// Item Name filter
if (!empty($_GET['item_name'])) {
    $where[] = "name LIKE ?";
    $params[] = "%" . $_GET['item_name'] . "%";
}

// Status filter
if (!empty($_GET['status'])) {
    $where[] = "status = ?";
    $params[] = $_GET['status'];
}

// Stock filter
if (!empty($_GET['stock_filter'])) {
    if ($_GET['stock_filter'] === 'out') {
        $where[] = "(SELECT COALESCE(SUM(amount), 0) FROM stock WHERE item_id = sales_items.id) <= 0";
    } elseif ($_GET['stock_filter'] === 'in') {
        $where[] = "(SELECT COALESCE(SUM(amount), 0) FROM stock WHERE item_id = sales_items.id) > 0";
    }
}

$sql = "SELECT * FROM sales_items";
if (!empty($where)) {
    $sql .= " WHERE " . implode(" AND ", $where);
}
$sql .= " ORDER BY id DESC";

$conn = $db->getConnection();
$stmt = $conn->prepare($sql);

if ($params) {
    // Assuming all params are strings, bind all as 's'
    $types = str_repeat('s', count($params));
    $stmt->bind_param($types, ...$params);
}

$stmt->execute();
$result = $stmt->get_result();
$allItems = $result->fetch_all(MYSQLI_ASSOC);

							if (empty($allItems)) {
    							echo "No rental items found.";
							} else {
    							foreach ($allItems as $item) {
                    $stockQty = $db->selectSumStock($item['id']);
                    $totalStock = $stockQty['total'] ?? 0;


    								?>
    									   <tr>
                        <td>
                         <span><?php echo htmlspecialchars($item['id']); ?></span>
                        </td>
                        <td><?php echo htmlspecialchars($item['name']); ?></td>
                        <td>LKR.                          <?php 
                          		$price = $item['price'];

								// Format to 2 decimals only if not already decimal
								if (floor($price) == $price) {
    								// It's an integer, format to 2 decimal places
    								$price = number_format($price, 2, '.', '');
								}

								// Then escape for HTML output
								echo htmlspecialchars($price);
                          ?>
                        </td>
                        <td><?php echo number_format($totalStock, 2); ?></td>

                        <td><span class="badge "><?php echo htmlspecialchars($item['status']); ?></span></td>
                        <td><span ><?php echo htmlspecialchars($item['date_added']); ?></span></td>
                     
                      </tr>
    								<?php
        						
    							}
							}
                    	?>
                   
                     
                    </tbody>
                  </table>
                </div>
              </div>

                      </div>
                    </div>
                  </div>
                </div>
              	</div>
              </div>
             
            </div>

            <script>
            	$(document).ready(function () {
  $('#itemTable').DataTable();
});

            </script>
            <!-- / Content -->
<?php include 'footer.php'; ?>