<?php include 'header.php'; ?>
<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);
?>

<?php

if (isset($_POST['add_item'])) {
	$item_name = $_POST['item_name'];
	$rental_price = $_POST['rental_price'];
	$DB = new DB();
	$insert = $DB->insert('sales_items', [
    'name' => $item_name,
    'price' => $rental_price
	]);
	if ($insert) {
		   echo "<script>window.location.href = 'sales_items.php?success=Success! Sales item added.';</script>";
	}else{
		   echo "<script>window.location.href = 'sales_items.php?error=Error! Could not add sales item.';</script>";
	}

}


if (isset($_GET['deactivate'])) {
  $deactivate = $_GET['deactivate'];
  $DB = new DB();
  $data = [
    'status' => 'Deactivated'
];
$success = $DB->update('sales_items', $data, $deactivate);

if ($success) {
    echo "<script>window.location.href = 'sales_items.php?success=Success! Sales item deactivated.';</script>";
} else {
    echo "<script>window.location.href = 'sales_items.php?error=Error! Could not deactivate sales item.';</script>";
}

}

if (isset($_GET['activate'])) {
  $activate = $_GET['activate'];
   $DB = new DB();
  $data = [
    'status' => 'Active'
];
$success = $DB->update('sales_items', $data, $activate);

if ($success) {
    echo "<script>window.location.href = 'sales_items.php?success=Success! Sales item Activated.';</script>";
} else {
    echo "<script>window.location.href = 'sales_items.php?error=Error! Could not Activated sales item.';</script>";
}
}
?>
     <!-- Content wrapper -->
          <div class="content-wrapper">
            <!-- Content -->
            <div class="container-xxl flex-grow-1 container-p-y">
            	<div class="card">
              <div class="row" style="  
    padding-top: 1%;
    padding-bottom: 1%;
    align-items: baseline;
    padding-left: 1%;
    border-radius: 8px;padding-right: 1%;">
              	<div class="col-lg-6">
              		<span style="font-weight: 800;font-size: 18px;color: black;">Sales Items Managment</span>
              	</div>
              	<div class="col-lg-6" style="align-content: stretch;
    display: flex
;
    flex-wrap: wrap;
    flex-direction: row;
    justify-content: flex-end;">
    <?php if ($userRole != "Staff") {
                      ?>
              					<button
                              type="button"
                              class="btn btn-primary"
                              data-bs-toggle="modal"
                              data-bs-target="#backDropModal">
                              Add New Item
                            </button>

                        <?php } ?>

                            <!-- Modal -->
                            <div class="modal fade" id="backDropModal" data-bs-backdrop="static" tabindex="-1">
                              <div class="modal-dialog">
                                <form class="modal-content" method="POST" action="sales_items.php">
                                  <div class="modal-header">
                                    <h5 class="modal-title" id="backDropModalTitle">Add New Sales Item</h5>
                                    <button
                                      type="button"
                                      class="btn-close"
                                      data-bs-dismiss="modal"
                                      aria-label="Close"></button>
                                  </div>
                                  <div class="modal-body">
                                    <div class="row">
                                      <div class="col mb-6">
                                        <label for="nameBackdrop"  class="form-label">Item Name</label>
                                        <input
                                          type="text"
                                          id="nameBackdrop"
                                          class="form-control"
                                          placeholder="Enter Item Name" name="item_name"  required="required" />
                                      </div>
                                    </div>
                                    <div class="row g-6">
                                      <div class="col mb-0">
                                        <label for="emailBackdrop" class="form-label">Item Sales Price</label>
                                        <input
                                          type="number"
                                          id="emailBackdrop"
                                          class="form-control"
                                          placeholder="50.00" name="rental_price" required="required" />
                                      </div>
                                      
                                    </div>
                                  </div>
                                  <div class="modal-footer">
                                    <button type="button" class="btn btn-label-secondary" data-bs-dismiss="modal">
                                      Close
                                    </button>
                                    <input type="submit" class="btn btn-primary" name="add_item" value="Submit">
                                  </div>
                                </form>
                              </div>
                            </div>


                          </div>
                        </div>
</div>
<div class="card" style="margin-top: 2%;">
    <div class="card-header">
        <form method="GET" action="sales_items.php" class="row g-2">
            <div class="col-md-4">
                <input type="text" name="item_name" class="form-control"
                       placeholder="Search by Item Name"
                       value="<?php echo isset($_GET['item_name']) ? htmlspecialchars($_GET['item_name']) : ''; ?>">
            </div>

            <div class="col-md-3">
                <select name="stock_filter" class="form-control">
                    <option value="">All Stock</option>
                    <option value="out" <?php echo (isset($_GET['stock_filter']) && $_GET['stock_filter'] === 'out') ? 'selected' : ''; ?>>
                        Out of Stock
                    </option>
                    <option value="in" <?php echo (isset($_GET['stock_filter']) && $_GET['stock_filter'] === 'in') ? 'selected' : ''; ?>>
                        In Stock
                    </option>
                </select>
            </div>

            <div class="col-md-3">
                <select name="status" class="form-control">
                    <option value="">All Status</option>
                    <option value="Active" <?php echo (isset($_GET['status']) && $_GET['status'] === 'Active') ? 'selected' : ''; ?>>
                        Active
                    </option>
                    <option value="Deactivated" <?php echo (isset($_GET['status']) && $_GET['status'] === 'Deactivated') ? 'selected' : ''; ?>>
                        Deactivated
                    </option>
                </select>
            </div>

            <div class="col-md-2">
                <button type="submit" class="btn btn-primary w-100">Filter</button>
            </div>
        </form>
    </div>
</div>


                      <div class="card" style="margin-top: 2%;">
                <h5 class="card-header">Sales Items</h5>
                <div class="table-responsive text-nowrap">
                  <table class="table">
                    <thead>
                      <tr>
                        <th>Item ID</th>
                        <th>Item Name</th>
                        <th>Price</th>
                        <th>Stock</th>
                        <th>Status</th>
                        <th>Date Added</th>
                        <th>Actions</th>
                      </tr>
                    </thead>
                    <tbody class="table-border-bottom-0">
                    	<?php
                    $db = new DB();
$where = [];
$params = [];

// Item Name filter
if (!empty($_GET['item_name'])) {
    $where[] = "name LIKE ?";
    $params[] = "%" . $_GET['item_name'] . "%";
}

// Status filter
if (!empty($_GET['status'])) {
    $where[] = "status = ?";
    $params[] = $_GET['status'];
}

// Stock filter
if (!empty($_GET['stock_filter'])) {
    if ($_GET['stock_filter'] === 'out') {
        $where[] = "(SELECT COALESCE(SUM(amount), 0) FROM stock WHERE item_id = sales_items.id) <= 0";
    } elseif ($_GET['stock_filter'] === 'in') {
        $where[] = "(SELECT COALESCE(SUM(amount), 0) FROM stock WHERE item_id = sales_items.id) > 0";
    }
}

$sql = "SELECT * FROM sales_items";
if (!empty($where)) {
    $sql .= " WHERE " . implode(" AND ", $where);
}
$sql .= " ORDER BY id DESC";

$conn = $db->getConnection();
$stmt = $conn->prepare($sql);

if ($params) {
    // Assuming all params are strings, bind all as 's'
    $types = str_repeat('s', count($params));
    $stmt->bind_param($types, ...$params);
}

$stmt->execute();
$result = $stmt->get_result();
$allItems = $result->fetch_all(MYSQLI_ASSOC);



							if (empty($allItems)) {
    							echo "No rental items found.";
							} else {
    							foreach ($allItems as $item) {
                    $stockQty = $db->selectSumStock($item['id']);
                    $totalStock = $stockQty['total'] ?? 0;
    								?>
    									   <tr>
                        <td>
                         <span><?php echo htmlspecialchars($item['id']); ?></span>
                        </td>
                        <td><?php echo htmlspecialchars($item['name']); ?></td>
                        <td>LKR.
                          <?php 
                          		$price = $item['price'];

								// Format to 2 decimals only if not already decimal
								if (floor($price) == $price) {
    								// It's an integer, format to 2 decimal places
    								$price = number_format($price, 2, '.', '');
								}

								// Then escape for HTML output
								echo htmlspecialchars($price);
                          ?>
                        </td>
                        <td><?php echo number_format($totalStock, 2); ?></td>
                        <td><span class="badge "><?php echo htmlspecialchars($item['status']); ?></span></td>
                        <td><span ><?php echo htmlspecialchars($item['date_added']); ?></span></td>
                        <td>
                            <?php if ($userRole != "Staff") {
                      ?>
                          <div class="dropdown">
                            <button type="button" class="btn p-0 dropdown-toggle hide-arrow" data-bs-toggle="dropdown">
                              <i class="icon-base bx bx-dots-vertical-rounded"></i>
                            </button>
                            <div class="dropdown-menu">
                              <a class="dropdown-item" href="single_sale_item.php?id=<?php echo $item["id"]; ?>"><i class="icon-base bx bx-edit-alt me-1"></i> Edit</a>
                              <?php
                              	if($item['status'] == "Active"){
                              		?>
                              		<a class="dropdown-item" href="sales_items.php?deactivate=<?php echo $item["id"]; ?>"><i class="icon-base bx bx-trash me-1"></i> Deactivate</a>
                              		<?php
                              	}else if($item['status'] == "Deactivated"){
                                  ?>
                                  <a class="dropdown-item" href="sales_items.php?activate=<?php echo $item["id"]; ?>"><i class="icon-base bx bx-success me-1"></i> Activate</a>
                                  <?php
                                }
                               ?>
                              
                            </div>
                          </div>
                      <?php } ?>
                        </td>
                      </tr>
    								<?php
        						
    							}
							}
                    	?>
                   
                     
                    </tbody>
                  </table>
                </div>
              </div>

                      </div>
                    </div>
                  </div>
                </div>
              	</div>
              </div>
             
            </div>

            <script>
            	$(document).ready(function () {
  $('#itemTable').DataTable();
});

            </script>
            <!-- / Content -->
<?php include 'footer.php'; ?>