<?php
include 'db.php';
$db = new DB();

$term = $_GET['term'] ?? '';
if (!$term) exit;

$conn = $db->getConnection();

$stmt = $conn->prepare("
    SELECT id, name, price,qty,item_code 
    FROM rental_items 
    WHERE status = 'Active' 
      AND qty > 0
      AND item_code LIKE ?
");
$search = "%$term%";
$stmt->bind_param("s", $search);
$stmt->execute();
$result = $stmt->get_result();

$suggestions = [];
while ($row = $result->fetch_assoc()) {
    $suggestions[] = [
        "label" => $row['name'] . ' (' . $row['item_code'] . ')',
        "value" => $row['name'],
        "id"    => $row['id'],
        "price" => $row['price'],
        "qty" => $row['qty'],
        "code" => $row['item_code']
    ];
}

echo json_encode($suggestions);
