<?php
require 'db.php';

ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

$db = new DB();
$conn = $db->getConnection();

$term = $_GET['term'] ?? '';
$termLike = "%$term%";

$sql = "
    SELECT si.id, si.name, si.price,
           IFNULL((SELECT SUM(s.amount) FROM stock s WHERE s.item_id = si.id), 0) AS stock
    FROM sales_items si
    WHERE si.status = 'Active' 
      AND si.name LIKE ?
    HAVING stock > 0
    LIMIT 10
";

$stmt = $conn->prepare($sql);
if (!$stmt) {
    die("Prepare failed: " . $conn->error);
}

$stmt->bind_param("s", $termLike);
$stmt->execute();

$result = $stmt->get_result();

$items = [];
while ($row = $result->fetch_assoc()) {
    $items[] = [
        'id' => $row['id'],
        'label' => $row['name'],
        'value' => $row['name'],
        'price' => $row['price'],
        'stock' => $row['stock']
    ];
}

header('Content-Type: application/json');
echo json_encode($items);
