<?php include 'header.php'; ?>
<?php
$db = new DB();
if (isset($_GET['id'])) {
  $customer_id = $_GET['id'];
  $customer = $db->selectById('customers', $customer_id);

  $cus_name    = $customer['name'];
  $cus_email   = $customer['email'];
  $cus_phone   = $customer['phone'];
  $cus_company = $customer['company'];
  $cus_idnumber = $customer['id_number'];
  $cus_address = $customer['address'];
  $cus_balance = $customer['balance'];
  $cus_status  = $customer['status'];
  $cus_fingerprint = $customer['fingerprint'];
  $cus_photo = $customer['photo'];
  $cus_id_front = $customer['cus_id_front_photo'];
  $cus_id_back = $customer['cus_id_back_photo'];
}

if (isset($_POST['update'])) {
  $customer_id = $_POST['customer_id'];
  $cus_name    = $_POST['name'];
  $cus_email   = $_POST['email'];
  $cus_phone   = $_POST['phone'];
  $cus_company = $_POST['company'];
  $cus_address = $_POST['address'];
  $cus_balance = $_POST['balance'];
  $cus_status  = $_POST['status'];
  $cus_idnumber = $_POST['id_number'];

  $data = [
    'name'     => $cus_name,
    'email'    => $cus_email,
    'phone'    => $cus_phone,
    'company'  => $cus_company,
    'address'  => $cus_address,
    'balance'  => $cus_balance,
    'status'   => $cus_status,
    'id_number' => $cus_idnumber,
  ];

  $success = $db->update('customers', $data, $customer_id);

  if ($success) {
    echo "<script>window.location.href = 'single_customer.php?success=Customer updated successfully.&id=$customer_id';</script>";
  } else {
    echo "<script>window.location.href = 'single_customer.php?error=Failed to update customer.&id=$customer_id';</script>";
  }
}

if (isset($_POST['update_finger'])) {
    $customer_id = $_POST['customer_id'];
    $DB = new DB();
    $fingerprint_path = '';

    if (isset($_FILES['cus_n_fringerprint']) && $_FILES['cus_n_fringerprint']['error'] === 0) {
        // Create upload directory if not exists
        $uploadDir = 'uploads/customers/';
        if (!is_dir($uploadDir)) {
            mkdir($uploadDir, 0777, true);
        }

        $fileTmp  = $_FILES['cus_n_fringerprint']['tmp_name'];
        $fileName = uniqid('finger_') . '_' . basename($_FILES['cus_n_fringerprint']['name']);
        $fileDest = $uploadDir . $fileName;

        if (move_uploaded_file($fileTmp, $fileDest)) {
            $fingerprint_path = $fileDest;

            // Update DB
            $update = $DB->update('customers', [
                'fingerprint' => $fingerprint_path
            ], $customer_id);

            if ($update) {
                echo "<script>window.location.href = 'single_customer.php?success=Fingerprint updated successfully&id=$customer_id';</script>";
            } else {
                echo "<script>window.location.href = 'single_customer.php?error=Database update failed&id=$customer_id';</script>";
            }
        } else {
            echo "<script>window.location.href = 'single_customer.php?error=File upload failed&id=$customer_id';</script>";
        }
    } else {
        echo "<script>window.location.href = 'single_customer.php?error=No file selected or upload error&id=$customer_id';</script>";
    }
}

if (isset($_POST['update_photo'])) {
    $customer_id = $_POST['customer_id'];
    $DB = new DB();
    $photo_path = '';

    if (isset($_FILES['cus_n_photo']) && $_FILES['cus_n_photo']['error'] === 0) {
        // Create upload directory if it doesn't exist
        $uploadDir = 'uploads/customers/';
        if (!is_dir($uploadDir)) {
            mkdir($uploadDir, 0777, true);
        }

        $tmpFile = $_FILES['cus_n_photo']['tmp_name'];
        $fileName = uniqid('photo_') . '_' . basename($_FILES['cus_n_photo']['name']);
        $destination = $uploadDir . $fileName;

        if (move_uploaded_file($tmpFile, $destination)) {
            $photo_path = $destination;

            // Update the photo in the database
            $update = $DB->update('customers', [
                'photo' => $photo_path
            ], $customer_id);

            if ($update) {
                echo "<script>window.location.href = 'single_customer.php?success=Photo updated successfully&id=$customer_id';</script>";
            } else {
                echo "<script>window.location.href = 'single_customer.php?error=Database update failed&id=$customer_id';</script>";
            }
        } else {
            echo "<script>window.location.href = 'single_customer.php?error=File upload failed&id=$customer_id';</script>";
        }
    } else {
        echo "<script>window.location.href = 'single_customer.php?error=No file selected or upload error&id=$customer_id';</script>";
    }
}


if (isset($_POST['update_id_front'])) {
    $customer_id = $_POST['customer_id'];
    $DB = new DB();
    $photo_path = '';

    if (isset($_FILES['photo_id_front']) && $_FILES['photo_id_front']['error'] === 0) {
        // Create upload directory if it doesn't exist
        $uploadDir = 'uploads/customers/';
        if (!is_dir($uploadDir)) {
            mkdir($uploadDir, 0777, true);
        }

        $tmpFile = $_FILES['photo_id_front']['tmp_name'];
        $fileName = uniqid('photo_') . '_' . basename($_FILES['photo_id_front']['name']);
        $destination = $uploadDir . $fileName;

        if (move_uploaded_file($tmpFile, $destination)) {
            $photo_path = $destination;

            // Update the photo in the database
            $update = $DB->update('customers', [
                ' cus_id_front_photo' => $photo_path
            ], $customer_id);

            if ($update) {
                echo "<script>window.location.href = 'single_customer.php?success=ID Front updated successfully&id=$customer_id';</script>";
            } else {
                echo "<script>window.location.href = 'single_customer.php?error=Database update failed&id=$customer_id';</script>";
            }
        } else {
            echo "<script>window.location.href = 'single_customer.php?error=File upload failed&id=$customer_id';</script>";
        }
    } else {
        echo "<script>window.location.href = 'single_customer.php?error=No file selected or upload error&id=$customer_id';</script>";
    }
}




if (isset($_POST['update_id_back'])) {
    $customer_id = $_POST['customer_id'];
    $DB = new DB();
    $photo_path = '';

    if (isset($_FILES['photo_id_back']) && $_FILES['photo_id_back']['error'] === 0) {
        // Create upload directory if it doesn't exist
        $uploadDir = 'uploads/customers/';
        if (!is_dir($uploadDir)) {
            mkdir($uploadDir, 0777, true);
        }

        $tmpFile = $_FILES['photo_id_back']['tmp_name'];
        $fileName = uniqid('photo_') . '_' . basename($_FILES['photo_id_back']['name']);
        $destination = $uploadDir . $fileName;

        if (move_uploaded_file($tmpFile, $destination)) {
            $photo_path = $destination;

            // Update the photo in the database
            $update = $DB->update('customers', [
                ' cus_id_back_photo' => $photo_path
            ], $customer_id);

            if ($update) {
                echo "<script>window.location.href = 'single_customer.php?success=ID Back updated successfully&id=$customer_id';</script>";
            } else {
                echo "<script>window.location.href = 'single_customer.php?error=Database update failed&id=$customer_id';</script>";
            }
        } else {
            echo "<script>window.location.href = 'single_customer.php?error=File upload failed&id=$customer_id';</script>";
        }
    } else {
        echo "<script>window.location.href = 'single_customer.php?error=No file selected or upload error&id=$customer_id';</script>";
    }
}


?>

    <div class="content-wrapper" >
  <div class="container-xxl flex-grow-1 container-p-y">
    <div class="card" style="margin-top: 2%;">
      <h5 class="card-header">Update Customer</h5>
      <div class="table-responsive text-nowrap">
        <div class="row" style="width: 100%;">
          <div class="col-lg-6">
    <div class="form-group" style="margin-top: 2%; align-items: center; justify-items: center; display: flex; align-content: space-around; justify-content: space-around; flex-direction: column;">
  <svg id="customerIdBarcode"></svg>
  <button onclick="printBarcode()" class="btn btn-secondary" style="margin-top: 10px;">Print Barcode</button>
</div>


            <form method="POST" action="single_customer.php" style="padding: 5%;">
              <input type="hidden" name="customer_id" value="<?php echo $customer_id; ?>">

              <div class="form-group">
                <label>Customer Name</label>
                <input type="text" name="name" class="form-control" value="<?php echo $cus_name; ?>" required>
              </div>

              <div class="form-group" style="margin-top: 2%;">
                <label>Customer Email</label>
                <input type="email" name="email" class="form-control" value="<?php echo $cus_email; ?>">
              </div>

              <div class="form-group" style="margin-top: 2%;">
                <label>Customer Phone</label>
                <input type="text" name="phone" class="form-control" value="<?php echo $cus_phone; ?>" required>
              </div>
              <div class="form-group" style="margin-top: 2%;">
                <label>Customer ID Number</label>
                <input type="text" name="id_number" class="form-control" value="<?php echo $cus_idnumber; ?>">
              </div>
              <div class="form-group" style="margin-top: 2%;">
                <label>Customer Company</label>
                <input type="text" name="company" class="form-control" value="<?php echo $cus_company; ?>">
              </div>


              <div class="form-group" style="margin-top: 2%;">
                <label>Customer Address</label>
                <textarea name="address" class="form-control"><?php echo $cus_address; ?></textarea>
              </div>

              <div class="form-group" style="margin-top: 2%;">
                <label>Customer Balance</label>
                <input type="number" name="balance" class="form-control" step="0.01" value="<?php echo $cus_balance; ?>" required>
              </div>

              <div class="form-group" style="margin-top: 2%;">
                <label>Status</label>
                <select name="status" class="form-control">
                  <option value="<?php echo $cus_status; ?>" selected><?php echo $cus_status; ?></option>
                  <option value="Active">Active</option>
                  <option value="Deactivated">Deactivated</option>
                </select>
              </div>

              <div class="form-group" style="margin-top: 3%;">
                <input type="submit" name="update" value="Update Now" class="btn btn-primary" style="width: 100%;">
              </div>
            </form>
          </div>

          <div class="col-lg-6" >
            <div class="row">


                <?php if ($userRole != "Staff") {
                      ?>
                <div class="col-lg-6">

                 <h6>Fringer Print Scan Copy</h6>
                <img style="width:100%;padding-top: 1.5%;border-radius: 5px;" src="<?php echo "$site_link"; ?>/<?php echo "$cus_fingerprint"; ?>">
              </div>
                <?php } ?>
              
              
              
              <div class="col-lg-6">
                <h6>Customer Photo</h6>
                <img style="width:100%;padding-top: 1.5%;border-radius: 5px;" src="<?php echo "$site_link"; ?>/<?php echo "$cus_photo"; ?>">
              </div>
            </div>
              <div class="row" style="padding-top: 3%;padding-bottom: 5%;">
              
              <div class="col-lg-6">
                <form enctype="multipart/form-data" method="POST" action="single_customer.php">
                  <input type="hidden" name="customer_id" value="<?php echo $customer_id; ?>">
                  <div class="form-group">
                    <label>Upload New Fringer Print Copy</label>
                    <input type="file" name="cus_n_fringerprint" class="form-control" style="margin-top:3%;" required="required">
                  </div>
                  <input type="submit" name="update_finger" value="Update" class="btn btn-primary" style="margin-top:3%;width: 100%;">
                </form>
              </div>
                <div class="col-lg-6">
                <form enctype="multipart/form-data" method="POST" action="single_customer.php">
                   <input type="hidden" name="customer_id" value="<?php echo $customer_id; ?>">
                  <div class="form-group">
                    <label>Upload New Customer Photo</label>
                    <input type="file" name="cus_n_photo" class="form-control" style="margin-top:3%;">
                  </div>
                  <input type="submit" name="update_photo" value="Update" class="btn btn-primary" style="margin-top:3%;width: 100%;">
                </form>
              </div>
            </div>
             <div class="row">
            <div class="col-lg-6">
               <h6>ID Front Copy</h6>
                <img style="width:100%;padding-top: 1.5%;border-radius: 5px;" src="<?php echo "$site_link"; ?>/<?php echo "$cus_id_front"; ?>">

                <form enctype="multipart/form-data" method="POST" action="single_customer.php">
                   <input type="hidden" name="customer_id" value="<?php echo $customer_id; ?>">
                  <div class="form-group">
                    <label>Upload New Customer Photo</label>
                    <input type="file" name="photo_id_front" class="form-control" style="margin-top:3%;">
                  </div>
                  <input type="submit" name="update_id_front" value="Update" class="btn btn-primary" style="margin-top:3%;width: 100%;">
                </form>
                <div style="height: 10px;"></div>
            </div>
            <div class="col-lg-6">
               <h6>ID Back Copy</h6>
                <img style="width:100%;padding-top: 1.5%;border-radius: 5px;" src="<?php echo "$site_link"; ?>/<?php echo "$cus_id_back"; ?>">
                <form enctype="multipart/form-data" method="POST" action="single_customer.php">
                   <input type="hidden" name="customer_id" value="<?php echo $customer_id; ?>">
                  <div class="form-group">
                    <label>Upload New Customer Photo</label>
                    <input type="file" name="photo_id_back" class="form-control" style="margin-top:3%;">
                  </div>
                  <input type="submit" name="update_id_back" value="Update" class="btn btn-primary" style="margin-top:3%;width: 100%;">
                </form>
                <div style="height: 10px;"></div>
            </div>
          </div>
          </div>

        </div>
      </div>
      <?php if ($userRole != "Staff") {
                      ?>
                    <button onclick="printCustomerDetails()" class="btn btn-success" style="margin-left: 2%;margin-right: 2%;margin-bottom: 2%;">
  Print Customer Details
</button>   
        <?php } ?>
         
    </div>

  <div class="card" style="margin-top: 2%;">
                <h5 class="card-header">Pending Rental</h5>
                <div class="table-responsive text-nowrap">
                                  <?php
                                  $db = new DB();


$conditions = ["r.status = 'Pending' AND r.customer_id = '$cus_idnumber'"];


$whereClause = implode(' AND ', $conditions);
$sql = "SELECT r.*, c.name as customer_name 
        FROM rental r 
        LEFT JOIN customers c ON r.customer_id = c.id_number 
        WHERE $whereClause 
        ORDER BY r.id DESC";

$pendingRentals = $db->rawQuery($sql);


?>
                  <table class="table">
                    <thead>
                      <tr>
                        <th>Rental ID</th>
                        <th>Cus. Name</th>
                        <th>Cus. ID</th>
                        <th>Total Bill</th>
                        <th>Total Payed</th>
                        <th>Total Due</th>
                        <th>Status</th>
                        <th>Date</th>
                        <th>Action</th>
                      </tr>
                    </thead>
                  <tbody class="table-border-bottom-0">
<?php
if (empty($pendingRentals)) {
    echo "<tr><td colspan='8'>No pending rentals found.</td></tr>";
} else {
    foreach ($pendingRentals as $rental) {
?>
<tr>
  <td><?= htmlspecialchars($rental['id']) ?></td>
  <td><?= htmlspecialchars($rental['customer_name']) ?></td> <!-- FIXED HERE -->
  <td><?= htmlspecialchars($rental['customer_id']) ?></td>
  <td><?= number_format($rental['total'], 2) ?></td> <!-- FIXED: use 'total' -->
  <td><?= number_format($rental['pay_amount'], 2) ?></td> <!-- FIXED: use 'pay_amount' -->
   <td><?= number_format(number_format($rental['total'], 2) - number_format($rental['pay_amount'], 2) ,2) ?></td> 
  <td><span class="badge bg-warning"><?= htmlspecialchars($rental['status']) ?></span></td>
  <td><?= date('Y-m-d', strtotime($rental['created_date'])) ?></td> <!-- FIXED: use 'created_date' -->
     <td ><a href="view_rental.php?id=<?= $rental['id'] ?>" class="btn btn-primary">View</a> </td>
</tr>
<?php
    }
}
?>
</tbody>

                  </table>
                </div>
              </div>
              
              
              
              <?php if ($userRole != "Staff") {
              ?>
              
               <div class="card" style="margin-top: 2%;">
                <h5 class="card-header">Completed Rental</h5>
                <div class="table-responsive text-nowrap">
                                  <?php
                                  $db = new DB();


$conditions = ["r.status = 'Completed' AND r.customer_id = '$cus_idnumber'"];


$whereClause = implode(' AND ', $conditions);
$sql = "SELECT r.*, c.name as customer_name 
        FROM rental r 
        LEFT JOIN customers c ON r.customer_id = c.id_number 
        WHERE $whereClause 
        ORDER BY r.id DESC";

$pendingRentals = $db->rawQuery($sql);


?>
                  <table class="table">
                    <thead>
                      <tr>
                        <th>Rental ID</th>
                        <th>Cus. Name</th>
                        <th>Cus. ID</th>
                        <th>Total Bill</th>
                        <th>Total Payed</th>
                        <th>Total Due</th>
                        <th>Status</th>
                        <th>Date</th>
                        <th>Action</th>
                      </tr>
                    </thead>
                  <tbody class="table-border-bottom-0">
<?php
if (empty($pendingRentals)) {
    echo "<tr><td colspan='8'>No pending rentals found.</td></tr>";
} else {
    foreach ($pendingRentals as $rental) {
?>
<tr>
  <td><?= htmlspecialchars($rental['id']) ?></td>
  <td><?= htmlspecialchars($rental['customer_name']) ?></td> <!-- FIXED HERE -->
  <td><?= htmlspecialchars($rental['customer_id']) ?></td>
  <td><?= number_format($rental['total'], 2) ?></td> <!-- FIXED: use 'total' -->
  <td><?= number_format($rental['pay_amount'], 2) ?></td> <!-- FIXED: use 'pay_amount' -->
   <td><?= number_format(number_format($rental['total'], 2) - number_format($rental['pay_amount'], 2) ,2) ?></td> 
  <td><span class="badge bg-success"><?= htmlspecialchars($rental['status']) ?></span></td>
  <td><?= date('Y-m-d', strtotime($rental['created_date'])) ?></td> <!-- FIXED: use 'created_date' -->
     <td ><a href="view_rental.php?id=<?= $rental['id'] ?>" class="btn btn-primary">View</a> </td>
</tr>
<?php
    }
}
?>
</tbody>

                  </table>
                </div>
              </div>
              
              <?php } ?>
              
  </div>
</div>
<div id="printArea" style="display:none;">
  <!-- Everything you want printed goes here -->
  <div class="row" style="width: 100%;">
    <div class="col-lg-6">
      <div class="form-group" style="margin-top: 2%; align-items: center; display: flex; flex-direction: column;">
        <svg id="customerIdBarcode"></svg>
      </div>

      <p><strong>Customer Name:</strong> <?php echo $cus_name; ?></p>
      <p><strong>Email:</strong> <?php echo $cus_email; ?></p>
      <p><strong>Phone:</strong> <?php echo $cus_phone; ?></p>
      <p><strong>ID Number:</strong> <?php echo $cus_idnumber; ?></p>
      <p><strong>Company:</strong> <?php echo $cus_company; ?></p>
      <p><strong>Address:</strong> <?php echo $cus_address; ?></p>x
      <p><strong>Status:</strong> <?php echo $cus_status; ?></p>
      <div style="display:flex;">
        <div style="width:50%;">
           <h6>Fingerprint</h6>
           <img style="width:50%;" src="<?php echo "$site_link"; ?>/<?php echo "$cus_fingerprint"; ?>">
        </div>
        <div style="width:50%;">
           <h6>Customer</h6>
           <img style="width:50%;" src="<?php echo "$site_link"; ?>/<?php echo "$cus_photo"; ?>">
        </div>
      </div>
      <div style="display:flex;">
        <div style="width:50%;">
           <h6>ID Front</h6>
           <img style="width:50%;" src="<?php echo "$site_link"; ?>/<?php echo "$cus_id_front"; ?>">
        </div>
        <div style="width:50%;">
           <h6>ID Back</h6>
           <img style="width:50%;" src="<?php echo "$site_link"; ?>/<?php echo "$cus_id_back"; ?>">
        </div>
      </div>
    </div>
  </div>
  
</div>





<script src="https://cdn.jsdelivr.net/npm/jsbarcode@3.11.5/dist/JsBarcode.all.min.js"></script>
<script>
function printCustomerDetails() {
  var printContents = document.getElementById("printArea").innerHTML;
  var win = window.open("", "_blank", "width=800,height=600");
  win.document.write(`
    <html>
      <head>
        <title>Print Customer Details</title>
        <style>
          body { font-family: Arial, sans-serif; padding: 20px; }
          img { max-width: 100%; height: auto; }
          svg { width: 300px; height: auto; }
        </style>
      </head>
      <body>
        ${printContents}
      </body>
    </html>
  `);
  win.document.close();
  win.focus();
  win.print();
  win.close();
}
</script>

<script>
  document.addEventListener("DOMContentLoaded", function () {
    var idNumber = "<?php echo $cus_idnumber; ?>";
    if (idNumber.trim() !== "") {
      JsBarcode("#customerIdBarcode", idNumber, {
        format: "CODE128",
        lineColor: "#000",
        width: 2,
        height: 50,
        displayValue: true
      });
    }
  });

  function printBarcode() {
    var barcode = document.getElementById("customerIdBarcode").outerHTML;
    var win = window.open("", "_blank");
    win.document.write(`
      <html>
        <head>
          <title>Print Barcode</title>
          <style>
            body { display: flex; justify-content: center; align-items: center; height: 100vh; margin: 0; }
            svg { width: 300px; height: auto; }
          </style>
        </head>
        <body onload="window.print(); window.close();">
          ${barcode}
        </body>
      </html>
    `);
    win.document.close();
  }
</script>


            <!-- / Content -->
<?php include 'footer.php'; ?>