<?php include 'header.php'; ?>

<?php
$db = new DB();

// Get filter values from GET request
$itemNameFilter = $_GET['item_name'] ?? '';
$startDate = $_GET['start_date'] ?? '';
$endDate = $_GET['end_date'] ?? '';
$stockTypeFilter = $_GET['stock_type'] ?? '';  // New filter for stock type

$where = [];
$params = [];

// Filter by item name
if (!empty($itemNameFilter)) {
    $where[] = "i.name LIKE ?";
    $params[] = "%" . $itemNameFilter . "%";
}

// Filter by date range
if (!empty($startDate) && !empty($endDate)) {
    $where[] = "s.date_added BETWEEN ? AND ?";
    $params[] = $startDate . " 00:00:00";
    $params[] = $endDate . " 23:59:59";
} elseif (!empty($startDate)) {
    $where[] = "s.date_added >= ?";
    $params[] = $startDate . " 00:00:00";
} elseif (!empty($endDate)) {
    $where[] = "s.date_added <= ?";
    $params[] = $endDate . " 23:59:59";
}

// Filter by stock type
if (!empty($stockTypeFilter) && in_array($stockTypeFilter, ['in', 'out'])) {
    $where[] = "s.stock_type = ?";
    $params[] = $stockTypeFilter;
}

$sql = "SELECT s.*, i.name AS item_name 
        FROM stock s
        LEFT JOIN sales_items i ON s.item_id = i.id";

if (!empty($where)) {
    $sql .= " WHERE " . implode(" AND ", $where);
}

$sql .= " ORDER BY s.id DESC";

$conn = $db->getConnection();
$stmt = $conn->prepare($sql);

if ($params) {
    $types = str_repeat('s', count($params));
    $stmt->bind_param($types, ...$params);
}

$stmt->execute();
$result = $stmt->get_result();
$stockLogs = $result->fetch_all(MYSQLI_ASSOC);
?>

<!-- Content wrapper -->
<div class="content-wrapper">
  <!-- Content -->
  <div class="container-xxl flex-grow-1 container-p-y">
    <div class="card">
      <h5 class="card-header">Sales Stock In/Out History</h5>

      <!-- Filter Form -->
      <form method="GET" action="" class="row g-3" style="padding: 1rem;">
        <div class="col-md-3">
          <input type="text" name="item_name" class="form-control" placeholder="Filter by Item Name" value="<?php echo htmlspecialchars($itemNameFilter); ?>">
        </div>
        <div class="col-md-2">
          <input type="date" name="start_date" class="form-control" placeholder="Start Date" value="<?php echo htmlspecialchars($startDate); ?>">
        </div>
        <div class="col-md-2">
          <input type="date" name="end_date" class="form-control" placeholder="End Date" value="<?php echo htmlspecialchars($endDate); ?>">
        </div>
        <div class="col-md-2">
          <select name="stock_type" class="form-select">
            <option value="">All Types</option>
            <option value="in" <?= ($stockTypeFilter === 'in') ? 'selected' : '' ?>>IN</option>
            <option value="out" <?= ($stockTypeFilter === 'out') ? 'selected' : '' ?>>OUT</option>
          </select>
        </div>
        <div class="col-md-3">
          <button type="submit" class="btn btn-primary w-100">Filter</button>
        </div>
      </form>

      <div class="table-responsive text-nowrap" style="padding-left:2%;padding-right: 2%;">
        <table class="table table-bordered" id="stockLogTable"> 
          <thead>
            <tr>
              <th>ID</th>
              <th>Item Name</th>
              <th>Stock Type</th>
              <th>Amount</th>
              <th>Date</th>
            </tr>
          </thead>
          <tbody>
            <?php if (!empty($stockLogs)): ?>
              <?php foreach ($stockLogs as $log): ?>
                <tr>
                  <td><?php echo $log['id']; ?></td>
                  <td><?php echo htmlspecialchars($log['item_name']); ?></td>
                  <td>
                    <?php if ($log['stock_type'] === 'in'): ?>
                      <span class="badge bg-success">IN</span>
                    <?php else: ?>
                      <span class="badge bg-danger">OUT</span>
                    <?php endif; ?>
                  </td>
                  <td><?php echo number_format(abs($log['amount']), 2); ?></td>
                  <td><?php echo htmlspecialchars($log['date_added'] ?? '-'); ?></td>
                </tr>
              <?php endforeach; ?>
            <?php else: ?>
              <tr><td colspan="5">No stock logs found.</td></tr>
            <?php endif; ?>
          </tbody>
        </table>
      </div>
    </div>
  </div>
</div>

<script>
  $(document).ready(function () {
    $('#stockLogTable').DataTable();
  });
</script>

<?php include 'footer.php'; ?>
