<?php
include 'header.php';
$db = new DB();
$conn = $db->getConnection();

$fromDate = $_GET['from_date'] ?? '';
$toDate = $_GET['to_date'] ?? '';

// Base query
$query = "
    SELECT p.id, p.sales_id, p.sales_type, p.note, p.amount, p.date, c.name AS customer_name,p.online_payment,p.ref_id
    FROM payment p
    LEFT JOIN sales s ON p.sales_id = s.id
    LEFT JOIN customers c ON s.customer_id = c.id_number
    WHERE 1
";

// Add date filters if set
if (!empty($fromDate)) {
    $query .= " AND p.date >= '" . $conn->real_escape_string($fromDate) . "'";
}
if (!empty($toDate)) {
    $query .= " AND p.date <= '" . $conn->real_escape_string($toDate) . " 23:59:59'";
}


$query .= " ORDER BY p.date DESC";
$result = $conn->query($query);

// Store all results in an array and calculate totals
$rows = [];
$totalIn = 0;
$totalOut = 0;

if ($result && $result->num_rows > 0) {
    while ($row = $result->fetch_assoc()) {
        $rows[] = $row;

        $amount = floatval($row['amount']);
        if ($amount >= 0) {
            $totalIn += $amount;
        } else {
            $totalOut += abs($amount);
        }
    }
}

?>

<div class="content-wrapper">
  <div class="container-xxl flex-grow-1 container-p-y">
    <h4>Payment Report <?= htmlspecialchars($fromDate) ?> - <?= htmlspecialchars($toDate) ?></h4>
<div class="row mb-4">
  <div class="col-md-4" style="margin-bottom:2%;"> 
    <div class="card bg-success text-white">
      <div class="card-body">
        <h5 class="card-title mb-1">Total In</h5>
        <p class="card-text fs-4">LKR <?= number_format($totalIn, 2) ?></p>
      </div>
    </div>
  </div>
  <div class="col-md-4" style="margin-bottom:2%;">
    <div class="card bg-danger text-white">
      <div class="card-body">
        <h5 class="card-title mb-1">Total Out</h5>
        <p class="card-text fs-4">LKR <?= number_format($totalOut, 2) ?></p>
      </div>
    </div>
  </div>
  <div class="col-md-4" style="margin-bottom:2%;">
    <div class="card bg-primary text-white">
      <div class="card-body">
        <h5 class="card-title mb-1">Net Total</h5>
        <p class="card-text fs-4">LKR <?= number_format($totalIn - $totalOut, 2) ?></p>
      </div>
    </div>
  </div>
</div>

    <!-- Filter Form -->
    <form method="GET" class="mb-3" style="display:none;">
      <div class="row">
        <div class="col-md-3">
          <label for="from_date">From Date</label>
          <input type="date" class="form-control" name="from_date" id="from_date" value="<?= htmlspecialchars($fromDate) ?>">
        </div>
        <div class="col-md-3">
          <label for="to_date">To Date</label>
          <input type="date" class="form-control" name="to_date" id="to_date" value="<?= htmlspecialchars($toDate) ?>">
        </div>
        <div class="col-md-3 align-self-end">
          <button type="submit" class="btn btn-primary">Filter</button>
          <a href="#" onclick="goToPaymentReportToday()" class="btn btn-secondary">Reset</a>
        </div>
      </div>
    </form>

    <div class="card">
      <div class="table-responsive">
        <table class="table table-bordered" id="paymentTable">
          <thead>
            <tr>
              <th>Payment ID</th>
              <th>Sale ID</th>
              <th>Note</th>
              <th>Amount (LKR)</th>
              <th>Type</th>
              <th>Method</th>
              <th>Date</th>
            </tr>
          </thead>
          <tbody>
          <tbody>
  <?php if (empty($rows)): ?>
    <tr>
      <td colspan="6" class="text-center">No payments found.</td>
    </tr>
  <?php else: ?>
    <?php foreach ($rows as $row): ?>
      <?php $amount = floatval($row['amount']); ?>
      <tr>
        <td><?= htmlspecialchars($row['id']) ?></td>
        <td>
          <?php if ($row['sales_type'] === 'Sale' && $row['sales_id']): ?>
            <a href="view_sale.php?id=<?= $row['sales_id'] ?>">
              <?= htmlspecialchars($row['sales_id']) ?>
            </a>
          <?php elseif ($row['sales_type'] === 'Rental' && $row['sales_id']): ?>
            <a href="view_rental.php?id=<?= $row['sales_id'] ?>">
              <?= htmlspecialchars($row['sales_id']) ?>
            </a>
          <?php else: ?>
            -
          <?php endif; ?>
        </td>
        <td><?= htmlspecialchars($row['note']) ?></td>
        <td><?= number_format($amount, 2) ?></td>
        <td><?= htmlspecialchars($row['sales_type']) ?></td>
        <td><?php if($row['online_payment'] == "1"){ echo"Online"; echo"<br>"; echo"REF : $row[ref_id]"; }else{ echo"Offline"; } ?></td>
        <td><?= htmlspecialchars(date('Y-m-d', strtotime($row['date']))) ?></td>
      </tr>
    <?php endforeach; ?>
  <?php endif; ?>
</tbody>

          </tbody>
        </table>
      </div>

      <!-- Totals Section -->
      <div class="card-footer">
        <div class="row">
          <div class="col-md-4">
            <strong>Total In:</strong> LKR <?= number_format($totalIn, 2) ?>
          </div>
          <div class="col-md-4">
            <strong>Total Out:</strong> LKR <?= number_format($totalOut, 2) ?>
          </div>
          <div class="col-md-4">
            <strong>Net Total:</strong> LKR <?= number_format($totalIn - $totalOut, 2) ?>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>

<!-- DataTables -->
<script>
  $(document).ready(function() {
    $('#paymentTable').DataTable();
  });
</script>

<?php include 'footer.php'; ?>
