<?php include 'header.php'; ?>

<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);
$db = new DB();
$conn = $db->getConnection();

// Handle Add User form submission
if (isset($_POST['add_user'])) {
    $name = $_POST['user_name'];
    $email = $_POST['user_email'];
    $password = password_hash($_POST['user_password'], PASSWORD_DEFAULT);
    $role = $_POST['user_role'];

    // Insert user into DB
    $insert = $db->insert('users', [
        'name'     => $name,
        'email'    => $email,
        'password' => $password,
        'role'     => $role
    ]);

    if ($insert) {
        echo "<script>window.location.href = 'user.php?success=User added successfully';</script>";
    } else {
        echo "<script>window.location.href = 'user.php?error=Failed to add user';</script>";
    }
}

// Handle Delete User request
if (isset($_GET['delete_user'])) {
    $delete_id = intval($_GET['delete_user']);
    $stmt = $conn->prepare("DELETE FROM users WHERE id = ?");
    $stmt->bind_param("i", $delete_id);
    $stmt->execute();
    $stmt->close();

    echo "<script>window.location.href = 'user.php?success=User deleted successfully';</script>";
}

// Fetch all users
$sql = "SELECT id, name, email, role FROM users ORDER BY id DESC";
$result = $conn->query($sql);
?>

<div class="content-wrapper">
  <div class="container-xxl flex-grow-1 container-p-y">

    <div class="card mb-3">
      <div class="row align-items-center p-3">
        <div class="col-lg-6">
          <h4>User Management</h4>
        </div>
        <div class="col-lg-6 text-end">
          <!-- Button trigger modal -->
          <button
            type="button"
            class="btn btn-primary"
            data-bs-toggle="modal"
            data-bs-target="#addUserModal"
          >
            Add New User
          </button>
        </div>
      </div>
    </div>

    <!-- Add User Modal -->
    <div
      class="modal fade"
      id="addUserModal"
      tabindex="-1"
      aria-labelledby="addUserModalLabel"
      aria-hidden="true"
    >
      <div class="modal-dialog">
        <form class="modal-content" method="POST" action="user.php">
          <div class="modal-header">
            <h5 class="modal-title" id="addUserModalLabel">Add New User</h5>
            <button
              type="button"
              class="btn-close"
              data-bs-dismiss="modal"
              aria-label="Close"
            ></button>
          </div>
          <div class="modal-body">
            <div class="mb-3">
              <label for="userName" class="form-label">Name</label>
              <input
                type="text"
                class="form-control"
                id="userName"
                name="user_name"
                required
              />
            </div>
            <div class="mb-3">
              <label for="userEmail" class="form-label">Email</label>
              <input
                type="email"
                class="form-control"
                id="userEmail"
                name="user_email"
                required
              />
            </div>
            <div class="mb-3">
              <label for="userPassword" class="form-label">Password</label>
              <input
                type="password"
                class="form-control"
                id="userPassword"
                name="user_password"
                required
              />
            </div>
            <div class="mb-3">
              <label for="userRole" class="form-label">Role</label>
              <select class="form-select" id="userRole" name="user_role" required>
                <option value="" disabled selected>Select Role</option>
                <option value="Staff">Staff</option>
                <option value="Admin">Admin</option>
              </select>
            </div>
          </div>
          <div class="modal-footer">
            <button
              type="button"
              class="btn btn-secondary"
              data-bs-dismiss="modal"
            >
              Close
            </button>
            <button type="submit" name="add_user" class="btn btn-primary">
              Submit
            </button>
          </div>
        </form>
      </div>
    </div>

    <!-- Users Table -->
    <div class="card" style="margin-top: 1rem;">
      <div class="table-responsive text-nowrap">
        <table class="table table-striped">
          <thead>
            <tr>
              <th>User ID</th>
              <th>Name</th>
              <th>Email</th>
              <th>Role</th>
              <th>Actions</th>
            </tr>
          </thead>
          <tbody>
            <?php if ($result->num_rows === 0): ?>
              <tr>
                <td colspan="5" class="text-center">No users found.</td>
              </tr>
            <?php else: ?>
              <?php while ($user = $result->fetch_assoc()): ?>
                <tr>
                  <td><?= htmlspecialchars($user['id']) ?></td>
                  <td><?= htmlspecialchars($user['name']) ?></td>
                  <td><?= htmlspecialchars($user['email']) ?></td>
                  <td><?= htmlspecialchars($user['role']) ?></td>
                  <td>
                    <a href="view_user.php?id=<?= $user['id'] ?>" class="btn btn-sm btn-info">View</a>
                    <a href="user.php?delete_user=<?= $user['id'] ?>" class="btn btn-sm btn-danger" onclick="return confirm('Are you sure you want to delete this user?');">Delete</a>
                  </td>
                </tr>
              <?php endwhile; ?>
            <?php endif; ?>
          </tbody>
        </table>
      </div>
    </div>
  </div>
</div>

<script>
  // Optionally you can add JavaScript for additional UX here
</script>

<?php include 'footer.php'; ?>
