<?php include 'header.php'; ?>
<?php
$db = new DB();
$conn = $db->getConnection();
date_default_timezone_set('Asia/Colombo');


if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['return_payment'])) {
    $amount = floatval($_POST['amount']);
    $amount = -abs($amount);  // always converts to negative

    $rentalId = intval($_POST['rental_id']);
    $note = "Return Payment For Rental ID | $rentalId";

    if ($amount >= 0) {
        echo "<script>alert('Invalid payment amount.');</script>";
    } else {

    date_default_timezone_set('Asia/Colombo'); 
    $startDatecustome = new DateTime();
    $mysqlDatecustom = $startDatecustome->format('Y-m-d H:i:s');
    
        $stmtInsert = $conn->prepare("INSERT INTO payment (sales_id,sales_type, amount, note,date) VALUES (?,?, ?, ?, ?)");
        $stmtInsert->bind_param("isdss", $rentalId,$s_type, $amount, $note,$mysqlDatecustom);
        $s_type = "Rental";
        if ($stmtInsert->execute()) {
            // Update rental table's pay_amount
            $stmtUpdate = $conn->prepare("UPDATE rental SET pay_amount = pay_amount + ? WHERE id = ?");
            $stmtUpdate->bind_param("di", $amount, $rentalId);
            $stmtUpdate->execute();

            echo "<script>window.location.href = 'view_rental.php?success=Rental Payment added successfully&id=$rentalId';</script>";
            exit;
        } else {
            echo "<script>window.location.href = 'view_rental.php?error=Failed to add Rental Payment&id=$rentalId';</script>";
        }
    }
}

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['add_payment'])) {
    $amount = floatval($_POST['amount']);
    $rentalId = intval($_POST['rental_id']);
    $note = "Initial Payment For Rental ID | $rentalId";
    $is_online_payment = isset($_POST['is_online_payment']) ? 1 : 0;
    $ref_id = $_POST['ref_number'] ?? null;
    
    if ($amount <= 0) {
        echo "<script>alert('Invalid payment amount.');</script>";
    } else {
        
        date_default_timezone_set('Asia/Colombo'); 
        $startDatecustome = new DateTime();
        $mysqlDatecustom = $startDatecustome->format('Y-m-d H:i:s');

        $stmtInsert = $conn->prepare("INSERT INTO payment (sales_id,sales_type, amount, note,online_payment,ref_id,date) VALUES (?,?, ?, ?, ?, ?, ?)");
        $stmtInsert->bind_param("isdssss", $rentalId,$s_type, $amount, $note,$is_online_payment,$ref_id,$mysqlDatecustom);
        $s_type = "Rental";
        if ($stmtInsert->execute()) {
            // Update rental table's pay_amount
            $stmtUpdate = $conn->prepare("UPDATE rental SET pay_amount = pay_amount + ? WHERE id = ?");
            $stmtUpdate->bind_param("di", $amount, $rentalId);
            $stmtUpdate->execute();

            echo "<script>window.location.href = 'view_rental.php?success=Rental Payment added successfully&id=$rentalId';</script>";
            exit;
        } else {
            echo "<script>window.location.href = 'view_rental.php?error=Failed to add Rental Payment&id=$rentalId';</script>";
        }
    }
}


if (isset($_GET['print_bill'])) {
    echo "<script>
        window.onload = function() {
            const prtBtn = document.getElementById('prt_bill');
            if (prtBtn) prtBtn.click();
        };
    </script>";
}


if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['close_bill'])) {
  $rentalId = intval($_POST['rental_id']);
  $total_amount_save = $_POST['total_amount_save'];
  $total_pay_amount_save = $_POST['total_pay_amount_save'];
  $additional = $_POST['old_ship_amount'];
  $discount = $_POST['discount'];
  $amount = floatval($_POST['pay_amount']);
  $status = "Completed";
  $special_note = $_POST['special_note'];
  $s_type = "Rental";
  $note = "Initial Payment For Rental ID | $rentalId";
  $is_online_payment = isset($_POST['is_online_payment']) ? 1 : 0;
  $ref_id = $_POST['ref_number'] ?? null;

  $stmtUpdate = $conn->prepare("UPDATE rental SET total = ?,pay_amount = ?,status = ?,discount = ?,note = ? WHERE id = ?");

  $stmtUpdate->bind_param("ssssss", $total_amount_save, $total_pay_amount_save,$status,$discount,$special_note,$rentalId);
  if ($stmtUpdate->execute()) {
    if ($amount >= 0) {
        
        date_default_timezone_set('Asia/Colombo'); 
        $startDatecustome = new DateTime();
        $mysqlDatecustom = $startDatecustome->format('Y-m-d H:i:s');
        
      $stmtInsert = $conn->prepare("INSERT INTO payment (sales_id,sales_type, amount, note,online_payment,ref_id,date) VALUES (?,?, ?, ?, ?, ?, ?)");
      $stmtInsert->bind_param("sssssss", $rentalId,$s_type, $amount, $note,$is_online_payment,$ref_id,$mysqlDatecustom);
      if ($stmtInsert->execute()) {
            echo "<script>window.location.href = 'view_rental.php?print_bill=1&success=Rental bill closed successfully&id=$rentalId';</script>";
      }else{
        echo "<script>window.location.href = 'view_rental.php?error=Failed to update Rental &id=$rentalId';</script>";
      }
    }

  }else{
    echo "<script>window.location.href = 'view_rental.php?error=Failed to update Rental &id=$rentalId';</script>";
  }
  
}


if (!isset($_GET['id']) || !is_numeric($_GET['id'])) {
    die('Invalid rental ID.');
}

$rentalId = (int) $_GET['id'];
// Fetch rental main record
$stmt = $conn->prepare("SELECT * FROM rental WHERE id = ?");
$stmt->bind_param("i", $rentalId);
$stmt->execute();
$rental = $stmt->get_result()->fetch_assoc();

if (!$rental) {
    die('Rental record not found.');
}
// Fetch related rental items
// Reset rental items result before re-looping
$stmtItems = $conn->prepare("
    SELECT i.name, ri.*
    FROM rental_items_issuse ri
    JOIN rental_items i ON ri.item_id = i.id
    WHERE ri.rental_id = ?
");
$stmtItems->bind_param("i", $rentalId);
$stmtItems->execute();
$rentalItems = $stmtItems->get_result();






// Fetch payment records related to this rental
$stmtPayments = $conn->prepare("SELECT * FROM payment WHERE sales_id = ?");
$stmtPayments->bind_param("i", $rentalId);
$stmtPayments->execute();
$paymentsResult = $stmtPayments->get_result();
$payments = [];

while ($row = $paymentsResult->fetch_assoc()) {
    $payments[] = $row; // store in array
}


$rentalItemsList = [];
while ($item = $rentalItems->fetch_assoc()) {
    $rentalItemsList[] = $item;
}



$customerId = (int) $rental['customer_id'];
$stmtCustomer = $conn->prepare("SELECT  name FROM customers WHERE id_number = ?");
$stmtCustomer->bind_param("i", $customerId);
$stmtCustomer->execute();
$customer = $stmtCustomer->get_result()->fetch_assoc();

?>



    <div class="content-wrapper">
  <div class="container-xxl flex-grow-1 container-p-y">
    <div class="card" style="margin-top: 2%;padding-top:2%;padding-right: 2%;padding-left: 2%;padding-bottom: 3%;">
      
        <h4>Rental Summary</h4>
        <div class="row">
          <div class="col-lg-6">
            <p><strong>Customer ID:</strong>(<?= $customer['name']; ?>) <?= htmlspecialchars($rental['customer_id']) ?></p>
<p><strong>Phone:</strong> <?= htmlspecialchars($rental['customer_phone']) ?></p>
 <p><strong>Receiver:</strong> <?= htmlspecialchars($rental['recvier_name']) ?> (<?= htmlspecialchars($rental['recvier_id']) ?>)</p>
          </div>
          <div class="col-lg-6">
            <p><strong>Email:</strong> <?= htmlspecialchars($rental['customer_email']) ?></p>
<p><strong>Address:</strong> <?= nl2br(htmlspecialchars($rental['customer_address'])) ?></p>
<p><strong>Status:</strong> <?= htmlspecialchars($rental['status']) ?></p>

          </div>

        </div>



<p><strong>Total:</strong> LKR. <?= number_format($rental['total'], 2) ?></p>
<p><strong>Paid:</strong> LKR. <?= number_format($rental['pay_amount'], 2) ?></p>
<div class="row">
  <div class="col-lg-6">
    <?php if ($rental['recvier_photo']): ?>
  <p><strong>Receiver Photo:</strong><br><img src="<?= $rental['recvier_photo'] ?>" width="150"></p>
<?php endif; ?>
  </div>
    <div class="col-lg-6">
      <div class="row">
        <div class="col-lg-6">
          <button class="btn btn-primary" type="button" id="prt_agreement">Print Agreement</button>
          <button type="button" class="btn btn-primary" onclick="printAgreementm()">
  Print Agreement Mobile
</button>

          <form id="email_form" method="POST" action="send_agreement.php" style="margin-top:4%;">
  <input type="hidden" name="html_content" id="html_content">
  <input type="hidden" name="rental_id" value="<?= $rentalId ?>">
  <input type="email" name="email" class="form-control" id="send_email" placeholder="Enter Email" required>
  <button class="btn btn-primary" type="submit" id="mail_agreement" style="margin-top: 10px;">Send Agreement to email</button>
</form>
        </div>
        <div class="col-lg-6">
          <button class="btn btn-primary" type="button" id="prt_bill">Print Bill</button>
             <button type="button" class="btn btn-primary" onclick="printBilltm()">
  Print Bill Mobile
</button>
          
               <form id="email_form_bill" method="POST" action="send_bill.php" style="margin-top:4%;">
<input type="hidden" name="html_content" id="bill_html_content">
  <input type="hidden" name="rental_id" value="<?= $rentalId ?>">
  <input type="email" name="email" class="form-control" id="send_email" placeholder="Enter Email" required>
  <button class="btn btn-primary" type="submit" id="mail_bill" style="margin-top: 10px;">Send Bill to email</button>
</form>
        </div>
      </div>




</div>

</div>


          
          

          <h5>Rental Items</h5>
          <div class="table-responsive text-nowrap">
<table class="table tablemain">
  <thead>
    <tr>
      <th>Item ID</th>
      <th>Item Code</th>
      <th>Item Name</th>
      <th>Item Qty</th>
      <th>Rental Price</th>
      <th>Estimated Delivery Date</th>
      <th>Rental Days</th>
      <th>Total</th>
      <th>Status</th>
      <th>Issue Date</th>
      <th>Recived Date</th>

      <th>Reciver Image</th>
      <th>Action</th>
    </tr>
  </thead>
  <tbody>
 <?php foreach ($rentalItemsList as $item): ?>
  <tr>
    <td><?= htmlspecialchars($item['item_id']) ?></td>
    <td><?= htmlspecialchars($item['code']) ?></td>
    <td><?= htmlspecialchars($item['name']) ?></td>
    <td><?= htmlspecialchars($item['qty']) ?></td>
    <td><?= number_format($item['price'], 2) ?></td>
    <td><?= htmlspecialchars($item['estimated_date']) ?></td>
    <td><?= htmlspecialchars($item['rental_days']) ?></td>
    <td><?= $item['total']; ?></td>

    <td><?= htmlspecialchars($item['status']) ?></td>
<td><?= date('Y-m-d H:i:s', strtotime($item['c_date'])) ?></td>
<td>
            <?php if ($item['status'] == "Recived"): ?>
              <?= htmlspecialchars($item['r_date']) ?>
            <?php else: ?>
              -
            <?php endif; ?>
          </td>
   
          <td>
            <?php if ($item['status'] == "Recived"): ?>
              <a href="<?= htmlspecialchars($item['reciver_photo']) ?>" target="_blank" class="btn btn-success">View</a>
            <?php else: ?>
              -
            <?php endif; ?>
          </td>

    <td>
      <?php if ($item['status'] == "Recived"): ?>
        -
      <?php else: ?>
        <a href="recived_item.php?rental_id=<?= $rentalId ?>&recived_id=<?= htmlspecialchars($item['id']) ?>&item_id=<?= htmlspecialchars($item['item_id']) ?>" class="btn btn-success">Mark Recived</a>
      <?php endif; ?>
    </td>
  </tr>
<?php endforeach; ?>

  </tbody>
</table>
</div>
          <div class="row" style="margin-top:5%;">
        
            <div class="col-lg-6">
               <div class="card mb-4">
        <div class="card-header">Summary</div>
        <div class="card-body">
            <p><strong>Subtotal:</strong> Rs. <?= number_format($rental['subtotal'], 2) ?></p>
            <p><strong>Discount:</strong> Rs. <?= number_format($rental['discount'], 2) ?></p>
            <p><strong>Transport Fee:</strong> Rs. <?= $rental['additional'] ?></p>
            <p><strong>Total:</strong> Rs. <?= number_format($rental['total'], 2) ?></p>
            <p><strong>Paid:</strong> Rs. <?=  number_format($rental['pay_amount'], 2) ?></p>
            <p><strong>Total Due:</strong> LKR. <?= number_format($rental['total'] - $rental['pay_amount'], 2) ?></p>
        </div>
    </div>
            </div>
            <div class="col-lg-6">
               <form method="POST" action="view_rental.php?id=<?= $rentalId ?>">
  <input type="hidden" name="rental_id" value="<?= $rentalId ?>">
 
  <div class="form-group">
    <label>Amount Pay</label>
    <input type="number" name="amount" class="form-control" value="0" step="0.01" min="0" max="<?= $rental['total']-$rental['pay_amount'] ?>" required>
  </div>
  

  <div class="form-check mt-4">
    <input type="checkbox" class="form-check-input" id="is_online_payment" name="is_online_payment" value="1">
    <label class="form-check-label" for="is_online_payment">Is Online Payment</label>
  </div>


<div class="" id="refNumberContainer" style="display: none;">
  <label for="ref_number">Reference ID</label>
  <input type="text" name="ref_number" id="ref_number" class="form-control" placeholder="Enter Reference ID">
</div>
  
  <div class="form-group">
    <input type="submit" name="add_payment" class="btn btn-primary" value="Add Payment" style="margin-top:2%;width: 100%;">
  </div>
</form>


<form method="POST" action="view_rental.php?id=<?= $rentalId ?>" style="margin-top: 3%;">
  <p>Return Payment</p>
  <input type="hidden" name="rental_id" value="<?= $rentalId ?>">
    <div class="form-group">
    <label>Amount Give</label>
    <input type="number" name="amount" class="form-control" value="0" step="0.01" min="0" max="<?= $rental['pay_amount']; ?>" required>
  </div>
  
  <div class="form-group">
    <input type="submit" name="return_payment" class="btn btn-primary" value="Return Payment" style="margin-top:2%;width: 100%;">
  </div>
</form>
            </div>
          </div>
         
              <div class="row" style="margin-top:5%;">
          <div class="col-lg-12">
            <p><strong>Payment History:</strong></p>
<?php if (count($payments) > 0): ?>
  <div class="table-responsive">
    <table class="table table-bordered">
      <thead>
        <tr>
          <th>Payment ID</th>
          <th>Amount (LKR)</th>
          <th>Method</th>
          <th>Date</th>
          <th>Notes</th>
        </tr>
      </thead>
      <tbody>
        <?php foreach ($payments as $payment): ?>
  <tr>
    <td><?= htmlspecialchars($payment['id']) ?></td>
    <td><?= number_format($payment['amount'], 2) ?></td>
    <td><?php if($payment['online_payment'] == "1"){ echo"Online"; echo"<br>"; echo"REF ID : $payment[ref_id]"; }else{ echo"Offline"; } ?></td>
    <td><?= htmlspecialchars($payment['date']) ?></td>
    <td><?= nl2br(htmlspecialchars($payment['note'])) ?></td>
  </tr>
<?php endforeach; ?>

      </tbody>
    </table>
  </div>
<?php else: ?>
  <p>No payments recorded for this rental.</p>
<?php endif; ?>
          </div>
          <div class="col-lg-6">
          

          </div>
        </div>
      
    </div>
  </div>
</div>

<?php
// Assume $rental['id'] is your rental ID

// Check if rental status is 'Pending'
$isPending = $rental['status'] === 'Pending';

// Check if all rental items are 'Recived'
$stmt = $conn->prepare("SELECT COUNT(*) as total, SUM(CASE WHEN status = 'Recived' THEN 1 ELSE 0 END) as received FROM rental_items_issuse WHERE rental_id = ?");
$stmt->bind_param("i", $rental['id']);
$stmt->execute();
$result = $stmt->get_result()->fetch_assoc();

$allReceived = $result['total'] > 0 && $result['total'] == $result['received'];
$enableCloseButton = $isPending && $allReceived;
?>

<!-- Trigger Button -->
<button class="btn btn-success"
        data-bs-toggle="modal"
        data-bs-target="#exampleModal"
        style="margin-left: 5%;margin-right: 5%;"
        <?= $enableCloseButton ? '' : 'disabled' ?>>
  Close This Rental ?
</button>


<!-- Modal Structure -->
<div class="modal fade" id="exampleModal" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
  <div class="modal-dialog modal-dialog-centered">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="exampleModalLabel">Close Rental</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
      </div>
      <div class="modal-body text-center">
        <div class="row">
        
          <div class="col-lg-6">
  <div class="card-header" style="text-align:left;">Summary</div>
  <div class="card-body">
    <p style="text-align:left;"><strong>Subtotal:</strong> Rs. <span id="summary_subtotal"><?= number_format($rental['subtotal'], 2) ?></span></p>
    <p style="text-align:left;"><strong>Discount:</strong> Rs. <span id="summary_discount"><?= number_format($rental['discount'], 2) ?></span></p>
    <p style="text-align:left;"><strong>Transport Fee:</strong> Rs. <span id="summary_additional"><?= number_format($rental['additional'], 2) ?></span></p>
    <p style="text-align:left;"><strong>Total:</strong> Rs. <b id="final_total_c"><?=  number_format($rental['total'], 2) ?></b></p>
    <p style="text-align:left;"><strong>Paid:</strong> Rs. <span id="summary_paid"><?=  number_format($rental['pay_amount'], 2) ?></span></p>
    <p style="text-align:left;"><strong>Total Due:</strong> LKR. <span id="summary_due"><?= number_format($rental['total'], 2)-number_format($rental['pay_amount'], 2) ?></span></p>
  </div>
</div>
          <div class="col-lg-6">
            <form method="POST"  action="view_rental.php">
              <div class="form-group">
                <label style="text-align:left;width: 100%;">Discount</label>
                <input type="number" name="discount" class="form-control" value="0" id="discount">
              </div>
              <br>
              <div class="form-group">
                  <label style="text-align:left;width: 100%;">Special Bill Note</label>
                  <textarea class="form-control" name="special_note"></textarea>
              </div>
             
              <div class="form-group" style="display:none;">
                <label style="text-align:left;width: 100%;">Transport Charge</label>
                <input type="number" name="additional" class="form-control" value=" <?= number_format($rental['additional'], 2) ?>" id="additional">
              </div>
              <br>
              <div class="form-group">
                <label style="text-align:left;width: 100%;">Payment</label>
                <input type="number" name="pay_amount" class="form-control" value="0" id="pay_amount">
              </div>
              <br>
               <div class="form-group">
    <div class="form-check">
      <input type="checkbox" class="form-check-input" id="is_online_payments" name="is_online_payment" value="1">
      <label style="    width: 100%;
    text-align: left;" class="form-check-label" for="is_online_payments">Is Online Payment</label>
    </div>
  </div>

  <div class="form-group" id="refNumberContainers" style="display: none;">
    <label for="ref_number" style="text-align:left;width: 100%;">Reference ID</label>
    <input type="text" name="ref_number" id="ref_numbers" class="form-control" placeholder="Enter Reference ID">
  </div>
  <br>
              <input type="hidden" name="old_total" value="<?= $rental['total']; ?>" id="old_total">
              <input type="hidden" name="old_pay_amount" value="<?= $rental['pay_amount']; ?>" id="old_pay_amount">
<input type="hidden" name="old_ship_amount" value="<?= $rental['additional']; ?>" id="old_ship_amount">

              <input type="hidden" name="total_amount_save" id="total_amount_save">
              <input type="hidden" name="total_pay_amount_save" id="total_pay_amount_save">
              <input type="hidden" name="rental_id" value="<?= $rentalId ?>">
               <br>
              <div class="form-group">
                <input type="submit" name="close_bill" class="btn btn-primary" value="Close Bill" style="width:100%;">
              </div>
            </form>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>



<div id="agreement_sectionmobilr" style="display: none;">
  <h3 style="text-align:center;margin-bottom: 0;">CHANDANA ENGINEERING & CONSTRUCTION</h3>
  <p style="text-align:center;">Vijithapura, Badullaroad, Magastota, Nuwaraeliya<br>052-4316 968 | 077 566 5007 | 071 79799304<br>chandanaengineering1975@gmail.com</p>
  <h5 style="text-align:center;">Rental Agreement.</h5>
   <img src="https://chandanaengineering.com/1.png" style="
    position: absolute;
    width: 10%;
    z-index: -1;
    right: 0;
    margin-top: -14%;">
     <img src="https://chandanaengineering.com/2.png" style="
    position: absolute;
    width: 10%;
    z-index: -1;
    left: 0;
    margin-top: -14%;">
     <img src="https://chandanaengineering.com/3.png" style="
    position: absolute;
    width: 10%;
    z-index: -1;
    left: 8%;
    margin-top: -9%;">
  <hr style="border: solid 2px black;">
  <p><strong>Date:</strong> <?= date("Y-m-d") ?></p>
  <p><strong>Agreement No:</strong> # <?= $rentalId ?></p>
    <img style="max-width: 100%;
                height: auto;" src="https://chandanaengineering.com/g2.PNG" />
 
 
 <table>
            <tr>
                <td>
                    <strong>Customer Details</strong><br>
                    ID Number: <?= htmlspecialchars($rental["customer_id"]) ?><br>
                    Name: <?= htmlspecialchars($customer["name"]) ?><br>
                    Address: <?= nl2br(htmlspecialchars($rental["customer_address"])) ?>
                </td>
                <td>
                    <strong>Receiver Details</strong><br>
                    Name: <?= htmlspecialchars($rental["recvier_name"]) ?> (<?= htmlspecialchars($rental["recvier_id"]) ?>)
                </td>
            </tr>
        </table>
 
  


<p style="    width: 100%;
    text-align: center;
    position: absolute;
    z-index: -1;
    opacity: 0.1;
    font-size: 40px;
    color: black;font-weight: bold;">CHANDANA ENGINEERING & CONSTRUCTION</p>
<table class="table">
  <thead>
    <tr>
      <th style="font-size:13px;">Item ID</th>
      <th style="font-size:13px;">Item Name</th>
      <th style="font-size:13px;">Rental Price</th>
      <th style="font-size:13px;">Qty</th>


      <th style="font-size:13px;">Issue Date</th>
    </tr>
  </thead>
  <tbody>

    <?php $ui; ?>
  <?php foreach ($rentalItemsList as $itemd): ?>
    <?php $ui = $ui+1; ?>
  <tr>
    <td style="font-size:12px;"><?= htmlspecialchars($ui) ?></td>
    <td style="font-size:12px;"><?= htmlspecialchars($itemd['name']) ?></td>
    <td style="font-size:12px;"><?= number_format($itemd['price'], 2) ?></td>
    <td style="font-size:12px;"><?= $itemd['qty']; ?></td>
    <td style="font-size:12px;"><?= date('Y-m-d H:i:s', strtotime($item['c_date'])) ?></td>
  </tr>
<?php endforeach; ?>

  </tbody>
</table>
 
  <div class="card mb-4" style="margin-top:2%;">
        <div class="card-header">Summary</div>
        <div class="card-body">
            <p><strong>Total:</strong> Rs. <?= number_format($rental['total'], 2) ?></p>
            <p><strong>Paid:</strong> Rs. <?=  number_format($rental['pay_amount'], 2) ?></p>
            <p><strong>Total Due:</strong> LKR. <?= number_format($rental['total'] - $rental['pay_amount'], 2) ?></p>
        </div>
    </div>
 <br>

</div>






<div id="agreement_section" style="display: none;">
  <h3 style="text-align:center;margin-bottom: 0;">CHANDANA ENGINEERING & CONSTRUCTION</h3>
  <p style="text-align:center;">Vijithapura, Badullaroad, Magastota, Nuwaraeliya<br>052-4316 968 | 077 566 5007 | 071 79799304<br>chandanaengineering1975@gmail.com</p>
  <h5 style="text-align:center;">ඉදිකිරීම් උපකරණ කුලී පදනම මත රැගෙනයාමේ ගීවිසුම.</h5>
   <img src="https://chandanaengineering.com/1.png" style="
    position: absolute;
    width: 10%;
    z-index: -1;
    right: 0;
    margin-top: -14%;">
     <img src="https://chandanaengineering.com/2.png" style="
    position: absolute;
    width: 10%;
    z-index: -1;
    left: 0;
    margin-top: -14%;">
     <img src="https://chandanaengineering.com/3.png" style="
    position: absolute;
    width: 10%;
    z-index: -1;
    left: 8%;
    margin-top: -9%;">
  <hr style="border: solid 2px black;">
  <p><strong>දිනය:</strong> <?= date("Y-m-d") ?></p>
  <p><strong>ගිවිසුම් අංකය:</strong> # <?= $rentalId ?></p>
  <ul style="    font-size: 10px;">
    <li>දිනකට/පැයකට කුලියට උපකරණ රැගෙන ගිය දිනයදා සිට ආපසු භාරදෙන දිනයද ඇතුලුව උපකරණය ගනුදෙනුකරු භාරයේ තබා ගන්නා කාලය සදහා කුලී මුදල් උපකරණ භාර දෙන අවස්තාවේ සම්පුර්ණයේන්ම පියවීමට ගනුදෙනුකරු බැදී සිටි.</li>
    <li>දිනයක කාලය ලෙස සැලකෙනුයේ උදැසන 09.00 සිට සවස 05.00 දක්වා වන අතර සවස 06න් පසුව වැඩකරන කාලය සදහා ගනුදෙනුකරු අමතර ගාස්තු පියවීමට බැදි සිටි.</li>
    <li>උපකරණය ගණුදෙනු කරු භාරගත් මොහොතේ සිට උපකරණය අප ආයතනය භාර දෙන මොහොත තෙක් ගනුදෙනුකරු උපකරණයට වන හානි සදහා වගකීම බාර ගත යුතු වේ.</li>
    <li>යම් හෙයකින් උපකරණයට හානි සිදු වුවොත් ඒ සදහා නව උපකරණයක් හෝ හානි පුරනය සදහා මුදල් ලබා දීමට ගණුදෙනුකරු බැදි සිටි.</li>
    <li>පොරොන්දු වු දිනය උපකරණ භාර දීමට අපොහොසත් වන බව දැන ගත හොත් ඒ පිලිබදව කලින් දැනුම් දීමක් කල යුතු වේ.</li>
    <li>භාණ්ඩය බාරදෙන අවස්තාවේ ඒ සදහා මුදල් ගෙවීමට ගණුදෙනු කරු අපොහොසත් උවහොත් එ සදහා ප්‍රමාද වන දිනකට 5% ක අමතර මුදලක් එකතු වේ.</li>
    <li>ගණුදෙනු කරු හට ලබා දෙන බර් කොඩ් කෙතයේ වගකීම ගණුදෙනුකරු  විසින් බාර ගත යුතුයි.</li>
  </ul>
  <p>ඉහත කොන්දේසි වලට එකගවී උපකරන ලබාගත්තෙමි.</p>
  <div class="row" style="    display: -webkit-inline-box;">
    <div class="col-lg-6" style="min-width: 50%;">
      <p>ගණුදෙනු කරුගේ විස්තර</p>
      <p>හැදුනුම්පත් අං. : <?= htmlspecialchars($rental['customer_id']) ?></p>
      <p>නම : <?= htmlspecialchars($customer['name']) ?></p>
      <p>ලිපිනය : <?= nl2br(htmlspecialchars($rental['customer_address'])) ?></p>
    </div>
    <div class="col-lg-6" style="min-width: 50%;margin-left: 4%;">
      <p>භාණ්ඩ ලබාගත් පුද්ගලයාගේ විස්තර</p>
      <p>නම : <?= htmlspecialchars($rental['recvier_name']) ?> (<?= htmlspecialchars($rental['recvier_id']) ?>)</p>
   
    </div>
  </div>
<p style="    width: 100%;
    text-align: center;
    position: absolute;
    z-index: -1;
    opacity: 0.1;
    font-size: 40px;
    color: black;font-weight: bold;">CHANDANA ENGINEERING & CONSTRUCTION</p>
<table class="table">
  <thead>
    <tr>
      <th style="font-size:13px;">Item ID</th>
      <th style="font-size:13px;">Item Name</th>
      <th style="font-size:13px;">Rental Price</th>
      <th style="font-size:13px;">Qty</th>


      <th style="font-size:13px;">Issue Date</th>
    </tr>
  </thead>
  <tbody>

    <?php $ui; ?>
  <?php foreach ($rentalItemsList as $itemd): ?>
    <?php $ui = $ui+1; ?>
  <tr>
    <td style="font-size:12px;"><?= htmlspecialchars($ui) ?></td>
    <td style="font-size:12px;"><?= htmlspecialchars($itemd['name']) ?></td>
    <td style="font-size:12px;"><?= number_format($itemd['price'], 2) ?></td>
    <td style="font-size:12px;"><?= $itemd['qty']; ?></td>
    <td style="font-size:12px;"><?= date('Y-m-d H:i:s', strtotime($item['c_date'])) ?></td>
  </tr>
<?php endforeach; ?>

  </tbody>
</table>
 
  <div class="card mb-4" style="margin-top:2%;">
        <div class="card-header">Summary</div>
        <div class="card-body">
            <p><strong>Total:</strong> Rs. <?= number_format($rental['total'], 2) ?></p>
            <p><strong>Paid:</strong> Rs. <?=  number_format($rental['pay_amount'], 2) ?></p>
            <p><strong>Total Due:</strong> LKR. <?= number_format($rental['total'] - $rental['pay_amount'], 2) ?></p>
        </div>
    </div>
 <br>

</div>



<div id="agreement_sectionmail" style="display: none;">
  <h3 style="text-align:center;margin-bottom: 0;">CHANDANA ENGINEERING & CONSTRUCTION</h3>
  <p style="text-align:center;">Vijithapura, Badullaroad, Magastota, Nuwaraeliya<br>052-4316 968 | 077 566 5007 | 071 79799304<br>chandanaengineering1975@gmail.com</p>
  <h5 style="text-align:center;">ඉදිකිරීම් උපකරණ කුලී පදනම මත රැගෙනයාමේ ගීවිසුම.</h5>
 
  <hr style="border: solid 2px black;">
  <p><strong>දිනය:</strong> <?= date("Y-m-d") ?></p>
  <p><strong>ගිවිසුම් අංකය:</strong> # <?= $rentalId ?></p>
  <ul style="    font-size: 10px;">
    <li>දිනකට/පැයකට කුලියට උපකරණ රැගෙන ගිය දිනයදා සිට ආපසු භාරදෙන දිනයද ඇතුලුව උපකරණය ගනුදෙනුකරු භාරයේ තබා ගන්නා කාලය සදහා කුලී මුදල් උපකරණ භාර දෙන අවස්තාවේ සම්පුර්ණයේන්ම පියවීමට ගනුදෙනුකරු බැදී සිටි.</li>
    <li>දිනයක කාලය ලෙස සැලකෙනුයේ උදැසන 09.00 සිට සවස 05.00 දක්වා වන අතර සවස 06න් පසුව වැඩකරන කාලය සදහා ගනුදෙනුකරු අමතර ගාස්තු පියවීමට බැදි සිටි.</li>
    <li>උපකරණය ගණුදෙනු කරු භාරගත් මොහොතේ සිට උපකරණය අප ආයතනය භාර දෙන මොහොත තෙක් ගනුදෙනුකරු උපකරණයට වන හානි සදහා වගකීම බාර ගත යුතු වේ.</li>
    <li>යම් හෙයකින් උපකරණයට හානි සිදු වුවොත් ඒ සදහා නව උපකරණයක් හෝ හානි පුරනය සදහා මුදල් ලබා දීමට ගණුදෙනුකරු බැදි සිටි.</li>
    <li>පොරොන්දු වු දිනය උපකරණ භාර දීමට අපොහොසත් වන බව දැන ගත හොත් ඒ පිලිබදව කලින් දැනුම් දීමක් කල යුතු වේ.</li>
    <li>භාණ්ඩය බාරදෙන අවස්තාවේ ඒ සදහා මුදල් ගෙවීමට ගණුදෙනු කරු අපොහොසත් උවහොත් එ සදහා ප්‍රමාද වන දිනකට 5% ක අමතර මුදලක් එකතු වේ.</li>
    <li>ගණුදෙනු කරු හට ලබා දෙන බර් කොඩ් කෙතයේ වගකීම ගණුදෙනුකරු  විසින් බාර ගත යුතුයි.</li>
  </ul>
  <p>ඉහත කොන්දේසි වලට එකගවී උපකරන ලබාගත්තෙමි.</p>
  <div class="row" style="    display: -webkit-inline-box;">
    <div class="col-lg-6" style="min-width: 50%;">
      <p>ගණුදෙනු කරුගේ විස්තර</p>
      <p>හැදුනුම්පත් අං. : <?= htmlspecialchars($rental['customer_id']) ?></p>
      <p>නම : <?= htmlspecialchars($customer['name']) ?></p>
      <p>ලිපිනය : <?= nl2br(htmlspecialchars($rental['customer_address'])) ?></p>
    </div>
    <div class="col-lg-6" style="min-width: 50%;margin-left: 4%;">
      <p>භාණ්ඩ ලබාගත් පුද්ගලයාගේ විස්තර</p>
      <p>නම : <?= htmlspecialchars($rental['recvier_name']) ?> (<?= htmlspecialchars($rental['recvier_id']) ?>)</p>
   
    </div>
  </div>

<table class="table">
  <thead>
    <tr>
      <th style="font-size:13px;">Item ID</th>
      <th style="font-size:13px;">Item Name</th>
      <th style="font-size:13px;">Rental Price</th>
      
      <th style="font-size:13px;">Qty</th>


      <th style="font-size:13px;">Issue Date</th>
    </tr>
  </thead>
  <tbody>

    <?php $ui; ?>
  <?php foreach ($rentalItemsList as $itemd): ?>
    <?php $ui = $ui+1; ?>
  <tr>
    <td style="font-size:12px;"><?= htmlspecialchars($ui) ?></td>
    <td style="font-size:12px;"><?= htmlspecialchars($itemd['name']) ?></td>
    <td style="font-size:12px;"><?= number_format($itemd['price'], 2) ?></td>
    <td style="font-size:12px;"><?= $itemd['qty']; ?></td>
    <td style="font-size:12px;"><?= date('Y-m-d H:i:s', strtotime($item['c_date'])) ?></td>
  </tr>
<?php endforeach; ?>

  </tbody>
</table>
 
  <div class="card mb-4" style="margin-top:2%;">
        <div class="card-header">Summary</div>
        <div class="card-body">
            <p><strong>Total:</strong> Rs. <?= number_format($rental['total'], 2) ?></p>
            <p><strong>Paid:</strong> Rs. <?=  number_format($rental['pay_amount'], 2) ?></p>
            <p><strong>Total Due:</strong> LKR. <?= number_format($rental['total'] - $rental['pay_amount'], 2) ?></p>
        </div>
    </div>
 <br>

</div>

<div id="bill_section" style="display: none;">
  <h1>CHANDANA ENGINEERING</h1><p style="text-align:left;">Vijithapura, Badullaroad, Magastota, Nuwaraeliya<br>052-4316 968 | 077 566 5007 | 071 79799304<br>chandanaengineering1975@gmail.com</p>

  <hr>
  <p style="text-align: left;"><strong>Date:</strong> <?= date("Y-m-d H:i:s") ?></p>
  <p style="text-align: left;"><strong>Bill No:</strong> <?= $rentalId ?></p>
  <hr>
  <p style="text-align: left;"><strong>Customer:</strong><br>
    <?= htmlspecialchars($customer['name']) ?><br>
  <?= htmlspecialchars($rental['customer_phone']) ?><br>
  <?= nl2br(htmlspecialchars($rental['customer_address'])) ?><br>
  <?= htmlspecialchars($rental['customer_id']) ?></p>
  <hr>
  <p style="text-align: left;"><strong>Items:</strong></p>
  <?php foreach ($rentalItemsList as $itemd): ?>
    <p style="text-align: left;"><?= htmlspecialchars($itemd['name']) ?>(x <?= $itemd['qty']; ?>)<br>
    <?= number_format($itemd['price'], 2) ?> x <?= htmlspecialchars($itemd['rental_days']) ?> = <?= number_format($itemd['total'], 2) ?> (<?= htmlspecialchars($itemd['status']) ?>) <?= date('Y-m-d H:i:s', strtotime($item['c_date'])) ?> - <?= htmlspecialchars($item['r_date']) ?></p>
  <?php endforeach; ?>
  <hr>
  <p>Special Note :  <?= htmlspecialchars($rental['note']) ?></p>
  <hr>
   <p style="text-align:left;"><strong>Subtotal:</strong> Rs. <?= number_format($rental['subtotal'], 2) ?></p>
            <p style="text-align:left;"><strong>Discount:</strong> Rs. <?= number_format($rental['discount'], 2) ?></p>
            <p style="text-align:left;"><strong>Transport Fee:</strong> Rs. <?= number_format($rental['additional'], 2) ?></p>
            <p style="text-align:left;"><strong>Total:</strong> Rs. <?= number_format($rental['total'], 2) ?></p>
            <p style="text-align:left;"><strong>Paid:</strong> Rs. <?=  number_format($rental['pay_amount'], 2) ?></p>
            <p style="text-align:left;"><strong>Total Due:</strong> LKR. <?= number_format($rental['total'] - $rental['pay_amount'], 2) ?></p>
  <hr>
  <p style="text-align: left;"><strong>Payments:</strong></p>
  <?php foreach ($payments as $payment): ?>
    <p style="text-align: left;"><?= number_format($payment['amount'], 2) ?> | <?= htmlspecialchars($payment['date']) ?></p>
  <?php endforeach; ?>
  <hr>
  <p style="text-align: left;">Thank you For Your Business !</p>
</div>




<script>
function printAgreementm() {
    // Get the HTML of the agreement section
    var content = document.getElementById("agreement_sectionmobilr").innerHTML;

    // Send via POST to PHP
    var form = document.createElement("form");
    form.method = "POST";
    form.action = "agreement_pdf.php";
    form.target = "_blank"; // Open PDF in new tab

    var input = document.createElement("input");
    input.type = "hidden";
    input.name = "html";
    input.value = content;
    form.appendChild(input);

    document.body.appendChild(form);
    form.submit();
    document.body.removeChild(form);
}



function printBilltm() {
    // Get the HTML of the agreement section
    var content = document.getElementById("bill_section").innerHTML;

    // Send via POST to PHP
    var form = document.createElement("form");
    form.method = "POST";
    form.action = "bill_pdf.php";
    form.target = "_blank"; // Open PDF in new tab

    var input = document.createElement("input");
    input.type = "hidden";
    input.name = "html";
    input.value = content;
    form.appendChild(input);

    document.body.appendChild(form);
    form.submit();
    document.body.removeChild(form);
}
</script>

<script>
document.getElementById('prt_bill').addEventListener('click', function () {
  const billContents = document.getElementById('bill_section').innerHTML;

  const win = window.open('', '', 'width=300,height=800'); // Approx. 80mm width
  win.document.write(`
    <html>
    <head>
      <title>Print Bill</title>
      <style>
        @media print {
          @page {
            size: 80mm auto;
            margin: 0;
          }
          body {
            font-family: monospace;
            font-size: 12px;
            margin: 0;
            padding: 10px;
            width: 80mm;
          }
          h1, p {
            margin: 5px 0;
            text-align: center;
          }
          hr {
            border: none;
            border-top: 1px dashed #000;
            margin: 5px 0;
          }
        }
        .section {
          margin-bottom: 10px;
        }
      </style>
    </head>
    <body onload="window.print(); window.close();">
      ${billContents}
    </body>
    </html>
  `);

  win.document.close();
});
</script>

<script>
document.getElementById('email_form_bill').addEventListener('submit', function(e) {
  const billHTML = document.getElementById('bill_section').innerHTML;
  document.getElementById('bill_html_content').value = billHTML;
});
</script>


<script>
document.getElementById('prt_agreement').addEventListener('click', function () {
  // Populate dynamic data

  const printContents = document.getElementById('agreement_section').innerHTML;

  const win = window.open('', '', 'height=1122,width=794'); // A4 size approx in px (96 DPI)
  win.document.write(`
    <html>
    <head>
      <title>Rental Agreement</title>
      <style>
        @page {
          size: A4;
          margin: 20mm;
        }
        body {
          font-family: Arial, sans-serif;
          font-size: 14px;
          padding: 20px;
        }
        h2 {
          text-align: center;
          margin-bottom: 30px;
        }
        p {
          margin-bottom: 12px;
        }
        .signature {
          margin-top: 50px;
        }
        table {
        width: 100%;
        border-collapse: collapse;
        margin-top: 20px;
      }
      table, th, td {
        border: 1px solid black;
      }
      </style>
    </head>
    <body>${printContents}</body>
    </html>
  `);

  win.document.close();
  win.focus();
  win.print();
  win.close();
});
</script>




<script>
document.getElementById('same_as_customer_btn').addEventListener('click', function () {
  let cus_name = $('#customer_name').val();
  let idNumber = $('#id_number_input').val();
  $('#receiver_name').val(cus_name);
  $('#receiver_id').val(idNumber);
});
</script>
<script>
$('#search_customer').on('click', function() {
    var idNumber = $('#id_number_input').val();

    if (!idNumber) {
        alert('Please enter an ID number.');
        return;
    }

    $.ajax({
        url: 'customer_search_ajax.php', // Change this to your PHP file path
        type: 'GET',
        data: { id_number: idNumber },
        dataType: 'json',
        success: function(response) {
          console.log(response);
           var customer_id = response.id;

          if (!customer_id) {
              alert('Invalid ID Number.');
              $('#customer_name').val('');
              $('#customer_phone').val('');
              $('#customer_email').val('');
              $('#customer_address').val('');
              return;
          }else{
              $('#customer_name').val(response.name);
              $('#customer_phone').val(response.phone);
              $('#customer_email').val(response.email);
              $('#customer_address').val(response.address);
          }
          

        },
        error: function(xhr) {
            $('#customer_result').html('<p style="color:red;">Error fetching data.</p>');
            console.error('Error:', xhr.responseText);
        }
    });
});
</script>
<script>
  let selectedItem = {};

  $(function () {
    $("#item_name").autocomplete({
      source: function (request, response) {
        $.ajax({
          url: "search_items.php",
          type: "GET",
          dataType: "json",
          data: { term: request.term },
          success: function (data) {
            response(data);
          }
        });
      },
      minLength: 2,
      select: function (event, ui) {
        selectedItem = ui.item;
        $('#item_name').val(ui.item.label); // Fill name in input
        return false;
      }
    });
  });
</script>

<script>
let rentalList = [];

$('#add_to_list_btn').on('click', function () {
  if (!selectedItem.id) {
    alert("Please select a valid item.");
    return;
  }

  const itemId = selectedItem.id;
  const itemName = selectedItem.label;
  const rentalPrice = parseFloat(selectedItem.price).toFixed(2);
  const estimatedDate = $('input[name="estimated_date"]').val();

  if (!estimatedDate) {
    alert("Please select estimated date of delivery.");
    return;
  }

  const today = new Date();
  const estDate = new Date(estimatedDate);
  today.setHours(0,0,0,0);
  estDate.setHours(0,0,0,0);

  const diffTime = estDate.getTime() - today.getTime();
  const rentalDays = Math.ceil(diffTime / (1000 * 60 * 60 * 24));

  if (rentalDays < 1) {
    alert("Estimated delivery date must be after today.");
    return;
  }

  const total = (rentalPrice * rentalDays).toFixed(2);

  rentalList.push({
    item_id: itemId,
    item_name: itemName,
    price: rentalPrice,
    rental_days: rentalDays,
    estimated_date: estimatedDate,
    total: total
  });

  $('#rental_items').val(JSON.stringify(rentalList));

  const newRow = `
    <tr>
      <td>${itemId}</td>
      <td>${itemName}</td>
      <td>${rentalPrice}</td>
      <td>${estimatedDate}</td>
      <td>${rentalDays}</td>
      <td>${total}</td>
      <td><button type="button" class="btn btn-danger btn-sm remove-item">X</button></td>
    </tr>
  `;

  $('.table tbody').append(newRow);
  updateTotal();
  $('#item_name').val('');
  selectedItem = {};
});

function updateTotal() {
  let total = 0;
  $('.tablemain tbody tr').each(function () {
    const rowTotal = parseFloat($(this).find('td:eq(7)').text());
    console.log(rowTotal);
    total += rowTotal;
  });

  $('span:contains("Total : LKR.")').html(`Total : LKR. ${total.toFixed(2)}`);
  $('#total_amount').val(total.toFixed(2));
}


// Handle removing item
$(document).on('click', '.remove-item', function () {
  const row = $(this).closest('tr');
  const itemId = row.find('td:eq(0)').text();

  // Remove from rentalList array
  rentalList = rentalList.filter(item => item.item_id !== itemId);

  // Update hidden input
  $('#rental_items').val(JSON.stringify(rentalList));

  // Remove row from table
  row.remove();

  // Recalculate total
  updateTotal();
});




</script>
<script>
document.getElementById('email_form').addEventListener('submit', function(e) {
  const agreementHTML = document.getElementById('agreement_sectionmail').innerHTML;
  document.getElementById('html_content').value = agreementHTML;
});
</script>

<script>
  function CalTotalAmount() {
    let discount = parseFloat($('#discount').val()) || 0;
    let additional = parseFloat($('#old_ship_amount').val()) || 0;
    let pay_amount = parseFloat($('#pay_amount').val()) || 0;
    let old_total = parseFloat($('#old_total').val()) || 0;
    let old_pay_amount = parseFloat($('#old_pay_amount').val()) || 0;

    // Calculate final total = old total - old paid - new payment - discount + additional fee
    let final_total = (old_total) - discount;
    let total_paid = old_pay_amount + pay_amount;
    let total_due = final_total - total_paid;
    // Display with 2 decimals
    $('#summary_discount').html(discount.toFixed(2));
    $('#summary_additional').html(additional.toFixed(2));
    $('#final_total_c').html(final_total.toFixed(2));
    $('#summary_paid').html(total_paid.toFixed(2));
    $('#summary_due').html(total_due.toFixed(2));
    $('#total_amount_save').val(final_total.toFixed(2));
    $('#total_pay_amount_save').val(total_paid.toFixed(2));
  }

  // Attach event listeners to all inputs on page load
  $(document).ready(function() {
    $('#discount, #additional, #pay_amount').on('input', CalTotalAmount);
    CalTotalAmount(); // Initial calculation on load
  });
</script>

<script>
  // Show/hide reference ID field based on checkbox
  document.getElementById('is_online_payment').addEventListener('change', function() {
    const refContainer = document.getElementById('refNumberContainer');
    const refInput = document.getElementById('ref_number');

    if (this.checked) {
      refContainer.style.display = 'block';
      refInput.setAttribute('required', 'required');
    } else {
      refContainer.style.display = 'none';
      refInput.removeAttribute('required');
    }
  });
</script>

<script>
  // Toggle Reference ID visibility
  document.getElementById('is_online_payments').addEventListener('change', function() {
    const refContainer = document.getElementById('refNumberContainers');
    const refInput = document.getElementById('ref_numbers');

    if (this.checked) {
      refContainer.style.display = 'block';
      refInput.setAttribute('required', 'required');
    } else {
      refContainer.style.display = 'none';
      refInput.removeAttribute('required');
    }
  });
</script>
            <!-- / Content -->
<?php include 'footer.php'; ?>