<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);
?>

<?php
include 'header.php';

$db = new DB();
$conn = $db->getConnection();

$saleId = isset($_GET['id']) ? (int)$_GET['id'] : 0;
if (!$saleId) {
    die("Invalid Sale ID");
}

// Fetch sale main info
// Fetch sale main info with customer details
$saleQuery = $conn->prepare("
    SELECT s.*, c.name AS customer_name, c.phone AS customer_phone, c.email AS customer_email, c.address AS customer_address
    FROM sales s
    LEFT JOIN customers c ON s.customer_id = c.id_number
    WHERE s.id = ?
");
$saleQuery->bind_param("i", $saleId);
$saleQuery->execute();
$saleResult = $saleQuery->get_result();
$sale = $saleResult->fetch_assoc();

if (!$sale) {
    die("Sale not found");
}

if (!$sale) {
    die("Sale not found");
}

// Fetch sale items
$itemsQuery = $conn->prepare("
    SELECT si.id, si.name, sitem.price, sitem.qty, (sitem.price * sitem.qty) AS total
    FROM sales_items_sold sitem
    JOIN sales_items si ON sitem.item_id = si.id
    WHERE sitem.sales_id = ?
");
$itemsQuery->bind_param("i", $saleId);
$itemsQuery->execute();
$itemsResult = $itemsQuery->get_result();

// Fetch payments
$paymentsQuery = $conn->prepare("
    SELECT note, amount, date, online_payment, ref_id 
    FROM payment 
    WHERE sales_id = ? AND sales_type = 'Sale'
");
$paymentsQuery->bind_param("i", $saleId);
$paymentsQuery->execute();
$paymentsResult = $paymentsQuery->get_result();
?>

<div class="content-wrapper">
  <div class="container-xxl flex-grow-1 container-p-y">
    <h4>Sale Details (ID: <?= htmlspecialchars($saleId) ?>)</h4>
    
    <div class="card mb-4">
      <div class="card-header">Customer Information</div>
      <div class="card-body">
        <p><strong>Name:</strong> <?= !empty($sale['customer_name']) ? htmlspecialchars($sale['customer_name']) : 'N/A' ?></p>

        <p><strong>Phone:</strong> <?= !empty($sale['customer_phone']) ? htmlspecialchars($sale['customer_phone']) : 'N/A' ?></p>
        <p><strong>Email:</strong> <?= !empty($sale['customer_email']) ? htmlspecialchars($sale['customer_email']) : 'N/A' ?></p>
        <p><strong>Address:</strong> <?= !empty($sale['customer_address']) ? htmlspecialchars($sale['customer_address']) : 'N/A' ?></p>
      </div>
    </div>
    
    <div class="card mb-4">
      <div class="card-header">Items Sold</div>
      <div class="table-responsive">
        <table class="table">
          <thead>
            <tr>
              <th>Item ID</th>
              <th>Name</th>
              <th>Price (LKR)</th>
              <th>Quantity</th>
              <th>Total (LKR)</th>
            </tr>
          </thead>
          <tbody>
            <?php
            $grandTotal = 0;
            while ($item = $itemsResult->fetch_assoc()) {
                $grandTotal += $item['total'];
                ?>
                <tr>
                  <td><?= htmlspecialchars($item['id']) ?></td>
                  <td><?= htmlspecialchars($item['name']) ?></td>
                  <td><?= number_format($item['price'], 2) ?></td>
                  <td><?= htmlspecialchars($item['qty']) ?></td>
                  <td><?= number_format($item['total'], 2) ?></td>
                </tr>
            <?php } ?>
          <tr>
  <td colspan="4" class="text-end"><strong>Transport Charge :</strong></td>
  <td><strong><?= number_format($sale['transport_charge'], 2) ?></strong></td>
</tr>
<tr>
  <td colspan="4" class="text-end"><strong>Grand Total:</strong></td>
  <td>
    <strong>
      <?= number_format($grandTotal + $sale['transport_charge'], 2) ?>
    </strong>
  </td>
</tr>

          </tbody>
        </table>
      </div>
    </div>

   <div class="card mb-4">
  <div class="card-header">Payments</div>
  <div class="table-responsive">
    <table class="table">
      <thead>
        <tr>
          <th>Note</th>
          <th>Amount (LKR)</th>
          <th>Method</th>
          <th>Date</th>
        </tr>
      </thead>
      <tbody>
        <?php 
        $totalPaid = 0;
        if ($paymentsResult->num_rows === 0) {
            echo '<tr><td colspan="3">No payments recorded.</td></tr>';
        } else {
            while ($payment = $paymentsResult->fetch_assoc()) {
                $totalPaid += $payment['amount'];
                ?>
                <tr>
                  <td><?= htmlspecialchars($payment['note']) ?></td>
                  <td><?= number_format($payment['amount'], 2) ?></td>
                  <td><?php if($payment['online_payment'] == "1"){ echo"Online"; echo"<br>"; echo"REF ID : $payment[ref_id]"; }else{ echo"Offline"; } ?></td>
                  <td><?= htmlspecialchars($payment['date']) ?></td>
                </tr>
        <?php }
        } ?>
        <tr>
          <td class="text-end"><strong>Total Paid:</strong></td>
          <td><strong><?= number_format($totalPaid, 2) ?></strong></td>
          <td></td>
        </tr>
        <?php 
        $dueBalance = ($grandTotal + $sale['transport_charge']) - $totalPaid;
        if ($dueBalance > 0) { ?>
          <tr>
            <td class="text-end text-danger"><strong>Due Balance:</strong></td>
            <td class="text-danger"><strong><?= number_format($dueBalance, 2) ?></strong></td>
            <td></td>
          </tr>
        <?php } ?>
      </tbody>
    </table>
  </div>

  <?php if ($dueBalance > 0) { ?>
    <div class="card-body " >
      <h6>Add Payment</h6>
      <form method="POST" action="add_payment.php">
  <input type="hidden" name="sales_id" value="<?= $saleId ?>">
  <input type="hidden" name="sales_type" value="Sale">

  <div class="mb-3">
    <label for="amount" class="form-label">Amount (LKR)</label>
    <input 
      type="number" 
      step="0.01" 
      max="<?= $dueBalance ?>" 
      class="form-control" 
      name="pay_amount" 
      id="amount" 
      required
    >
  </div>

  <div class="form-check mb-3">
    <input 
      class="form-check-input" 
      type="checkbox" 
      value="1" 
      id="is_online_payment" 
      name="is_online_payment"
    >
    <label class="form-check-label" for="is_online_payment">
      Is Online Payment
    </label>
  </div>

  <div class="mb-3" id="ref_number_box" style="display: none;">
    <label for="ref_number" class="form-label">Reference ID</label>
    <input 
      type="text" 
      class="form-control" 
      name="ref_number" 
      id="ref_number" 
      placeholder="Enter Reference ID"
    >
  </div>

  <button type="submit" class="btn btn-success">Add Payment</button>
</form>
    </div>
  <?php } ?>
</div>


    <a href="sales_list.php" class="btn btn-secondary">Back to Sales List</a>
  </div>
</div>
<script>
document.getElementById('is_online_payment').addEventListener('change', function() {
  const refBox = document.getElementById('ref_number_box');
  const refInput = document.getElementById('ref_number');

  if (this.checked) {
    refBox.style.display = 'block';
    refInput.setAttribute('required', 'required');
  } else {
    refBox.style.display = 'none';
    refInput.removeAttribute('required');
    refInput.value = '';
  }
});
</script>
<?php include 'footer.php'; ?>
