<?php
include 'header.php';

$db = new DB();
$conn = $db->getConnection();

$userId = isset($_GET['id']) ? intval($_GET['id']) : 0;
if (!$userId) {
    die("Invalid User ID");
}

// Handle form submission
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $name = $_POST['user_name'] ?? '';
    $password = $_POST['user_password'] ?? '';

    if (empty($name)) {
        $error = "Name cannot be empty.";
    } else {
        if (!empty($password)) {
            // Hash new password
            $hashedPassword = password_hash($password, PASSWORD_DEFAULT);
            $stmt = $conn->prepare("UPDATE users SET name = ?, password = ? WHERE id = ?");
            $stmt->bind_param("ssi", $name, $hashedPassword, $userId);
        } else {
            // Update only name
            $stmt = $conn->prepare("UPDATE users SET name = ? WHERE id = ?");
            $stmt->bind_param("si", $name, $userId);
        }
        if ($stmt->execute()) {
            $success = "User updated successfully.";
        } else {
            $error = "Failed to update user.";
        }
        $stmt->close();
    }
}

// Fetch user data for display
$stmt = $conn->prepare("SELECT id, name, email, role FROM users WHERE id = ?");
$stmt->bind_param("i", $userId);
$stmt->execute();
$result = $stmt->get_result();
$user = $result->fetch_assoc();
$stmt->close();

if (!$user) {
    die("User not found.");
}
?>

<div class="content-wrapper">
  <div class="container-xxl flex-grow-1 container-p-y">
    <h4>User Details (ID: <?= htmlspecialchars($user['id']) ?>)</h4>

    <?php if (isset($error)): ?>
      <div class="alert alert-danger"><?= htmlspecialchars($error) ?></div>
    <?php elseif (isset($success)): ?>
      <div class="alert alert-success"><?= htmlspecialchars($success) ?></div>
    <?php endif; ?>

    <form method="POST" action="view_user.php?id=<?= $user['id'] ?>">
      <div class="mb-3">
        <label class="form-label">Name</label>
        <input type="text" name="user_name" class="form-control" value="<?= htmlspecialchars($user['name']) ?>" required />
      </div>

      <div class="mb-3">
        <label class="form-label">Email (readonly)</label>
        <input type="email" class="form-control" value="<?= htmlspecialchars($user['email']) ?>" readonly />
      </div>

      <div class="mb-3">
        <label class="form-label">Role (readonly)</label>
        <input type="text" class="form-control" value="<?= htmlspecialchars($user['role']) ?>" readonly />
      </div>

      <div class="mb-3">
        <label class="form-label">Password (leave blank to keep current)</label>
        <input type="password" name="user_password" class="form-control" />
      </div>

      <button type="submit" class="btn btn-primary">Update User</button>
      <a href="user.php" class="btn btn-secondary">Back to Users</a>
    </form>
  </div>
</div>

<?php include 'footer.php'; ?>
